@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The QoSPolicyOverrides of a cluster.
 * @property bandwidthPercentageSMB This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property priorityValue8021ActionCluster This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property priorityValue8021ActionSMB This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 */
public data class QosPolicyOverridesResponse(
    public val bandwidthPercentageSMB: String? = null,
    public val priorityValue8021ActionCluster: String? = null,
    public val priorityValue8021ActionSMB: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.QosPolicyOverridesResponse):
            QosPolicyOverridesResponse = QosPolicyOverridesResponse(
            bandwidthPercentageSMB = javaType.bandwidthPercentageSMB().map({ args0 -> args0 }).orElse(null),
            priorityValue8021ActionCluster = javaType.priorityValue8021ActionCluster().map({ args0 ->
                args0
            }).orElse(null),
            priorityValue8021ActionSMB = javaType.priorityValue8021ActionSMB().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
