@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Suppress

/**
 * The DeploymentStatus of AzureStackHCI Cluster.
 * @property deploymentStatus Deployment status of AzureStackHCI Cluster Deployment.
 * @property validationStatus validation status of AzureStackHCI Cluster Deployment.
 */
public data class ReportedPropertiesResponse(
    public val deploymentStatus: DeploymentStatusResponse,
    public val validationStatus: ValidationStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ReportedPropertiesResponse):
            ReportedPropertiesResponse = ReportedPropertiesResponse(
            deploymentStatus = javaType.deploymentStatus().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.DeploymentStatusResponse.Companion.toKotlin(args0)
            }),
            validationStatus = javaType.validationStatus().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.ValidationStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
