@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
 * @property packageName Friendly name of the prerequisite.
 * @property updateType Updatable component type.
 * @property version Version of the prerequisite.
 */
public data class UpdatePrerequisiteResponse(
    public val packageName: String? = null,
    public val updateType: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.UpdatePrerequisiteResponse):
            UpdatePrerequisiteResponse = UpdatePrerequisiteResponse(
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            updateType = javaType.updateType().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
