@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The observed state of virtual hard disks
 * @property errorCode VirtualHardDisk provisioning error code
 * @property errorMessage Descriptive error message
 * @property provisioningStatus
 */
public data class VirtualHardDiskStatusResponse(
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val provisioningStatus: VirtualHardDiskStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualHardDiskStatusResponse):
            VirtualHardDiskStatusResponse = VirtualHardDiskStatusResponse(
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualHardDiskStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
