@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property operationId The ID of the operation performed on the virtual network
 * @property status The status of the operation performed on the virtual network [Succeeded, Failed, InProgress]
 */
public data class VirtualNetworkStatusResponseProvisioningStatus(
    public val operationId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualNetworkStatusResponseProvisioningStatus):
            VirtualNetworkStatusResponseProvisioningStatus =
            VirtualNetworkStatusResponseProvisioningStatus(
                operationId = javaType.operationId().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
