@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin

import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.StoragePropertiesResponse
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.StoragePropertiesResponse.Companion.toKotlin as storagePropertiesResponseToKotlin
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AzureBareMetalStorageInstance].
 */
@PulumiTagMarker
public class AzureBareMetalStorageInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureBareMetalStorageInstanceArgs = AzureBareMetalStorageInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureBareMetalStorageInstanceArgsBuilder.() -> Unit) {
        val builder = AzureBareMetalStorageInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureBareMetalStorageInstance {
        val builtJavaResource =
            com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureBareMetalStorageInstance(builtJavaResource)
    }
}

/**
 * AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
 * Azure REST API version: 2023-04-06.
 * Other available API versions: 2023-08-04-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Put a new AzureBareMetalStorageInstance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureBareMetalStorageInstance = new AzureNative.BareMetalInfrastructure.AzureBareMetalStorageInstance("azureBareMetalStorageInstance", new()
 *     {
 *         AzureBareMetalStorageInstanceName = "myAzureBareMetalStorageInstance",
 *         AzureBareMetalStorageInstanceUniqueIdentifier = "23415635-4d7e-41dc-9598-8194f22c24e9",
 *         Location = "westus2",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProperties = new AzureNative.BareMetalInfrastructure.Inputs.StoragePropertiesArgs
 *         {
 *             Generation = "Gen4",
 *             HardwareType = "NetApp",
 *             OfferingType = "EPIC",
 *             ProvisioningState = AzureNative.BareMetalInfrastructure.ProvisioningState.Succeeded,
 *             StorageBillingProperties = new AzureNative.BareMetalInfrastructure.Inputs.StorageBillingPropertiesArgs
 *             {
 *                 AzureBareMetalStorageInstanceSize = "",
 *                 BillingMode = "PAYG",
 *             },
 *             StorageType = "FC",
 *             WorkloadType = "ODB",
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/baremetalinfrastructure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := baremetalinfrastructure.NewAzureBareMetalStorageInstance(ctx, "azureBareMetalStorageInstance", &baremetalinfrastructure.AzureBareMetalStorageInstanceArgs{
 * 			AzureBareMetalStorageInstanceName:             pulumi.String("myAzureBareMetalStorageInstance"),
 * 			AzureBareMetalStorageInstanceUniqueIdentifier: pulumi.String("23415635-4d7e-41dc-9598-8194f22c24e9"),
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProperties: &baremetalinfrastructure.StoragePropertiesArgs{
 * 				Generation:        pulumi.String("Gen4"),
 * 				HardwareType:      pulumi.String("NetApp"),
 * 				OfferingType:      pulumi.String("EPIC"),
 * 				ProvisioningState: pulumi.String(baremetalinfrastructure.ProvisioningStateSucceeded),
 * 				StorageBillingProperties: &baremetalinfrastructure.StorageBillingPropertiesArgs{
 * 					AzureBareMetalStorageInstanceSize: pulumi.String(""),
 * 					BillingMode:                       pulumi.String("PAYG"),
 * 				},
 * 				StorageType:  pulumi.String("FC"),
 * 				WorkloadType: pulumi.String("ODB"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance;
 * import com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs;
 * import com.pulumi.azurenative.baremetalinfrastructure.inputs.StoragePropertiesArgs;
 * import com.pulumi.azurenative.baremetalinfrastructure.inputs.StorageBillingPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureBareMetalStorageInstance = new AzureBareMetalStorageInstance("azureBareMetalStorageInstance", AzureBareMetalStorageInstanceArgs.builder()
 *             .azureBareMetalStorageInstanceName("myAzureBareMetalStorageInstance")
 *             .azureBareMetalStorageInstanceUniqueIdentifier("23415635-4d7e-41dc-9598-8194f22c24e9")
 *             .location("westus2")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProperties(StoragePropertiesArgs.builder()
 *                 .generation("Gen4")
 *                 .hardwareType("NetApp")
 *                 .offeringType("EPIC")
 *                 .provisioningState("Succeeded")
 *                 .storageBillingProperties(StorageBillingPropertiesArgs.builder()
 *                     .azureBareMetalStorageInstanceSize("")
 *                     .billingMode("PAYG")
 *                     .build())
 *                 .storageType("FC")
 *                 .workloadType("ODB")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:baremetalinfrastructure:AzureBareMetalStorageInstance myAzureBareMetalStorageInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BareMetalInfrastructure/bareMetalStorageInstances/{azureBareMetalStorageInstanceName}
 * ```
 */
public class AzureBareMetalStorageInstance internal constructor(
    override val javaResource:
    com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance,
) : KotlinCustomResource(javaResource, AzureBareMetalStorageInstanceMapper) {
    /**
     * Specifies the AzureBareMetaStorageInstance unique ID.
     */
    public val azureBareMetalStorageInstanceUniqueIdentifier: Output<String>?
        get() = javaResource.azureBareMetalStorageInstanceUniqueIdentifier().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the storage properties for the AzureBareMetalStorage instance.
     */
    public val storageProperties: Output<StoragePropertiesResponse>?
        get() = javaResource.storageProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storagePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureBareMetalStorageInstanceMapper : ResourceMapper<AzureBareMetalStorageInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance::class == javaResource::class

    override fun map(javaResource: Resource): AzureBareMetalStorageInstance =
        AzureBareMetalStorageInstance(
            javaResource as
                com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance,
        )
}

/**
 * @see [AzureBareMetalStorageInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureBareMetalStorageInstance].
 */
public suspend fun azureBareMetalStorageInstance(
    name: String,
    block: suspend AzureBareMetalStorageInstanceResourceBuilder.() -> Unit,
):
    AzureBareMetalStorageInstance {
    val builder = AzureBareMetalStorageInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureBareMetalStorageInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureBareMetalStorageInstance(name: String): AzureBareMetalStorageInstance {
    val builder = AzureBareMetalStorageInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
