@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about an application in a Batch account.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### ApplicationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.Batch.Application("application", new()
 *     {
 *         AccountName = "sampleacct",
 *         AllowUpdates = false,
 *         ApplicationName = "app1",
 *         DisplayName = "myAppName",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewApplication(ctx, "application", &batch.ApplicationArgs{
 * 			AccountName:       pulumi.String("sampleacct"),
 * 			AllowUpdates:      pulumi.Bool(false),
 * 			ApplicationName:   pulumi.String("app1"),
 * 			DisplayName:       pulumi.String("myAppName"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.Application;
 * import com.pulumi.azurenative.batch.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .accountName("sampleacct")
 *             .allowUpdates(false)
 *             .applicationName("app1")
 *             .displayName("myAppName")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:Application app1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}
 * ```
 * @property accountName The name of the Batch account.
 * @property allowUpdates A value indicating whether packages within the application may be overwritten using the same version string.
 * @property applicationName The name of the application. This must be unique within the account.
 * @property defaultVersion The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
 * @property displayName The display name for the application.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 */
public data class ApplicationArgs(
    public val accountName: Output<String>? = null,
    public val allowUpdates: Output<Boolean>? = null,
    public val applicationName: Output<String>? = null,
    public val defaultVersion: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.ApplicationArgs =
        com.pulumi.azurenative.batch.ApplicationArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowUpdates(allowUpdates?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .defaultVersion(defaultVersion?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var allowUpdates: Output<Boolean>? = null

    private var applicationName: Output<String>? = null

    private var defaultVersion: Output<String>? = null

    private var displayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("gslodggyfwwtsryl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value A value indicating whether packages within the application may be overwritten using the same version string.
     */
    @JvmName("oujlvhnghlhoxggt")
    public suspend fun allowUpdates(`value`: Output<Boolean>) {
        this.allowUpdates = value
    }

    /**
     * @param value The name of the application. This must be unique within the account.
     */
    @JvmName("adiedcltqgtfpdyo")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
     */
    @JvmName("tfreyrpefmcakpvi")
    public suspend fun defaultVersion(`value`: Output<String>) {
        this.defaultVersion = value
    }

    /**
     * @param value The display name for the application.
     */
    @JvmName("hberoglgsxlnsmmi")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("rkiokpajhsgiebbb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("hmuhnmuvkabtbiou")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value A value indicating whether packages within the application may be overwritten using the same version string.
     */
    @JvmName("msmlfrasvdgnycqr")
    public suspend fun allowUpdates(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUpdates = mapped
    }

    /**
     * @param value The name of the application. This must be unique within the account.
     */
    @JvmName("wedxeipigiuvqsbl")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
     */
    @JvmName("qqntwligvypvppfy")
    public suspend fun defaultVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVersion = mapped
    }

    /**
     * @param value The display name for the application.
     */
    @JvmName("nihvjmtmcjmeawuv")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("ifsyxuxburtmldmi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        accountName = accountName,
        allowUpdates = allowUpdates,
        applicationName = applicationName,
        defaultVersion = defaultVersion,
        displayName = displayName,
        resourceGroupName = resourceGroupName,
    )
}
