@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.ApplicationPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An application package which represents a particular version of an application.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-09-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### ApplicationPackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationPackage = new AzureNative.Batch.ApplicationPackage("applicationPackage", new()
 *     {
 *         AccountName = "sampleacct",
 *         ApplicationName = "app1",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *         VersionName = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewApplicationPackage(ctx, "applicationPackage", &batch.ApplicationPackageArgs{
 * 			AccountName:       pulumi.String("sampleacct"),
 * 			ApplicationName:   pulumi.String("app1"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 			VersionName:       pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.ApplicationPackage;
 * import com.pulumi.azurenative.batch.ApplicationPackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationPackage = new ApplicationPackage("applicationPackage", ApplicationPackageArgs.builder()
 *             .accountName("sampleacct")
 *             .applicationName("app1")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .versionName("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:ApplicationPackage 1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}
 * ```
 * @property accountName The name of the Batch account.
 * @property applicationName The name of the application. This must be unique within the account.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 * @property versionName The version of the application.
 */
public data class ApplicationPackageArgs(
    public val accountName: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val versionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.ApplicationPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.ApplicationPackageArgs =
        com.pulumi.azurenative.batch.ApplicationPackageArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .versionName(versionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPackageArgs].
 */
@PulumiTagMarker
public class ApplicationPackageArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var versionName: Output<String>? = null

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("ivaklrvstpggwoiy")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the application. This must be unique within the account.
     */
    @JvmName("ulvqbytnkfhrfumw")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("ydwqewswapojcabt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The version of the application.
     */
    @JvmName("awlliowlsxlrxmwi")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value The name of the Batch account.
     */
    @JvmName("ysrclrvlbnvvcqcb")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the application. This must be unique within the account.
     */
    @JvmName("otuvnuipecvjbcfo")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("pflmtiuhdsslyxut")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The version of the application.
     */
    @JvmName("upaqssyahyryscvi")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    internal fun build(): ApplicationPackageArgs = ApplicationPackageArgs(
        accountName = accountName,
        applicationName = applicationName,
        resourceGroupName = resourceGroupName,
        versionName = versionName,
    )
}
