@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin

import com.pulumi.azurenative.batch.BatchAccountArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.AuthenticationMode
import com.pulumi.azurenative.batch.kotlin.enums.PoolAllocationMode
import com.pulumi.azurenative.batch.kotlin.enums.PublicNetworkAccessType
import com.pulumi.azurenative.batch.kotlin.inputs.AutoStorageBasePropertiesArgs
import com.pulumi.azurenative.batch.kotlin.inputs.AutoStorageBasePropertiesArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.BatchAccountIdentityArgs
import com.pulumi.azurenative.batch.kotlin.inputs.BatchAccountIdentityArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.batch.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.KeyVaultReferenceArgs
import com.pulumi.azurenative.batch.kotlin.inputs.KeyVaultReferenceArgsBuilder
import com.pulumi.azurenative.batch.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.batch.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Contains information about an Azure Batch account.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2017-01-01, 2022-01-01, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### BatchAccountCreate_BYOS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         KeyVaultReference = new AzureNative.Batch.Inputs.KeyVaultReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample",
 *             Url = "http://sample.vault.azure.net/",
 *         },
 *         Location = "japaneast",
 *         PoolAllocationMode = AzureNative.Batch.PoolAllocationMode.UserSubscription,
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			KeyVaultReference: &batch.KeyVaultReferenceArgs{
 * 				Id:  pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample"),
 * 				Url: pulumi.String("http://sample.vault.azure.net/"),
 * 			},
 * 			Location:           pulumi.String("japaneast"),
 * 			PoolAllocationMode: batch.PoolAllocationModeUserSubscription,
 * 			ResourceGroupName:  pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .keyVaultReference(KeyVaultReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample")
 *                 .url("http://sample.vault.azure.net/")
 *                 .build())
 *             .location("japaneast")
 *             .poolAllocationMode("UserSubscription")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### BatchAccountCreate_Default
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         Location = "japaneast",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .location("japaneast")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### BatchAccountCreate_SystemAssignedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         Identity = new AzureNative.Batch.Inputs.BatchAccountIdentityArgs
 *         {
 *             Type = AzureNative.Batch.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "japaneast",
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			Identity: &batch.BatchAccountIdentityArgs{
 * 				Type: batch.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .identity(BatchAccountIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("japaneast")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateBatchAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var batchAccount = new AzureNative.Batch.BatchAccount("batchAccount", new()
 *     {
 *         AccountName = "sampleacct",
 *         AutoStorage = new AzureNative.Batch.Inputs.AutoStorageBasePropertiesArgs
 *         {
 *             StorageAccountId = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage",
 *         },
 *         KeyVaultReference = new AzureNative.Batch.Inputs.KeyVaultReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample",
 *             Url = "http://sample.vault.azure.net/",
 *         },
 *         Location = "japaneast",
 *         PublicNetworkAccess = AzureNative.Batch.PublicNetworkAccessType.Disabled,
 *         ResourceGroupName = "default-azurebatch-japaneast",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/batch/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := batch.NewBatchAccount(ctx, "batchAccount", &batch.BatchAccountArgs{
 * 			AccountName: pulumi.String("sampleacct"),
 * 			AutoStorage: &batch.AutoStorageBasePropertiesArgs{
 * 				StorageAccountId: pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage"),
 * 			},
 * 			KeyVaultReference: &batch.KeyVaultReferenceArgs{
 * 				Id:  pulumi.String("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample"),
 * 				Url: pulumi.String("http://sample.vault.azure.net/"),
 * 			},
 * 			Location:            pulumi.String("japaneast"),
 * 			PublicNetworkAccess: batch.PublicNetworkAccessTypeDisabled,
 * 			ResourceGroupName:   pulumi.String("default-azurebatch-japaneast"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.batch.BatchAccount;
 * import com.pulumi.azurenative.batch.BatchAccountArgs;
 * import com.pulumi.azurenative.batch.inputs.AutoStorageBasePropertiesArgs;
 * import com.pulumi.azurenative.batch.inputs.KeyVaultReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var batchAccount = new BatchAccount("batchAccount", BatchAccountArgs.builder()
 *             .accountName("sampleacct")
 *             .autoStorage(AutoStorageBasePropertiesArgs.builder()
 *                 .storageAccountId("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Storage/storageAccounts/samplestorage")
 *                 .build())
 *             .keyVaultReference(KeyVaultReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.KeyVault/vaults/sample")
 *                 .url("http://sample.vault.azure.net/")
 *                 .build())
 *             .location("japaneast")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("default-azurebatch-japaneast")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:batch:BatchAccount sampleacct /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}
 * ```
 * @property accountName A name for the Batch account which must be unique within the region. Batch account names must be between 3 and 24 characters in length and must use only numbers and lowercase letters. This name is used as part of the DNS name that is used to access the Batch service in the region in which the account is created. For example: http://accountname.region.batch.azure.com/.
 * @property allowedAuthenticationModes List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
 * @property autoStorage The properties related to the auto-storage account.
 * @property encryption Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
 * @property identity The identity of the Batch account.
 * @property keyVaultReference A reference to the Azure key vault associated with the Batch account.
 * @property location The region in which to create the account.
 * @property networkProfile The network profile only takes effect when publicNetworkAccess is enabled.
 * @property poolAllocationMode The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService.
 * @property publicNetworkAccess If not specified, the default value is 'enabled'.
 * @property resourceGroupName The name of the resource group that contains the Batch account.
 * @property tags The user-specified tags associated with the account.
 */
public data class BatchAccountArgs(
    public val accountName: Output<String>? = null,
    public val allowedAuthenticationModes: Output<List<AuthenticationMode>>? = null,
    public val autoStorage: Output<AutoStorageBasePropertiesArgs>? = null,
    public val encryption: Output<EncryptionPropertiesArgs>? = null,
    public val identity: Output<BatchAccountIdentityArgs>? = null,
    public val keyVaultReference: Output<KeyVaultReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val poolAllocationMode: Output<PoolAllocationMode>? = null,
    public val publicNetworkAccess: Output<PublicNetworkAccessType>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.BatchAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.BatchAccountArgs =
        com.pulumi.azurenative.batch.BatchAccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowedAuthenticationModes(
                allowedAuthenticationModes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoStorage(autoStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultReference(keyVaultReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .poolAllocationMode(
                poolAllocationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BatchAccountArgs].
 */
@PulumiTagMarker
public class BatchAccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var allowedAuthenticationModes: Output<List<AuthenticationMode>>? = null

    private var autoStorage: Output<AutoStorageBasePropertiesArgs>? = null

    private var encryption: Output<EncryptionPropertiesArgs>? = null

    private var identity: Output<BatchAccountIdentityArgs>? = null

    private var keyVaultReference: Output<KeyVaultReferenceArgs>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var poolAllocationMode: Output<PoolAllocationMode>? = null

    private var publicNetworkAccess: Output<PublicNetworkAccessType>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A name for the Batch account which must be unique within the region. Batch account names must be between 3 and 24 characters in length and must use only numbers and lowercase letters. This name is used as part of the DNS name that is used to access the Batch service in the region in which the account is created. For example: http://accountname.region.batch.azure.com/.
     */
    @JvmName("wrnemyaontevilwg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     */
    @JvmName("bemtoemtctyjglpi")
    public suspend fun allowedAuthenticationModes(`value`: Output<List<AuthenticationMode>>) {
        this.allowedAuthenticationModes = value
    }

    @JvmName("ahllmyffrokddvcr")
    public suspend fun allowedAuthenticationModes(vararg values: Output<AuthenticationMode>) {
        this.allowedAuthenticationModes = Output.all(values.asList())
    }

    /**
     * @param values List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     */
    @JvmName("qekkrclpotfnsstn")
    public suspend fun allowedAuthenticationModes(values: List<Output<AuthenticationMode>>) {
        this.allowedAuthenticationModes = Output.all(values)
    }

    /**
     * @param value The properties related to the auto-storage account.
     */
    @JvmName("gspcleaiwplmgahq")
    public suspend fun autoStorage(`value`: Output<AutoStorageBasePropertiesArgs>) {
        this.autoStorage = value
    }

    /**
     * @param value Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     */
    @JvmName("qoqkghjesbxiivse")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identity of the Batch account.
     */
    @JvmName("amariukscbvpjqdq")
    public suspend fun identity(`value`: Output<BatchAccountIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value A reference to the Azure key vault associated with the Batch account.
     */
    @JvmName("eungkviosdhhntkd")
    public suspend fun keyVaultReference(`value`: Output<KeyVaultReferenceArgs>) {
        this.keyVaultReference = value
    }

    /**
     * @param value The region in which to create the account.
     */
    @JvmName("dmtvffsjihulhddj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network profile only takes effect when publicNetworkAccess is enabled.
     */
    @JvmName("toyyqweiummgbpqj")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService.
     */
    @JvmName("wqcnhliwhnqwcvor")
    public suspend fun poolAllocationMode(`value`: Output<PoolAllocationMode>) {
        this.poolAllocationMode = value
    }

    /**
     * @param value If not specified, the default value is 'enabled'.
     */
    @JvmName("rwalsbjchytofboj")
    public suspend fun publicNetworkAccess(`value`: Output<PublicNetworkAccessType>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("hvvcbugfujqnaoyr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The user-specified tags associated with the account.
     */
    @JvmName("fgtwuxiotiaaxwrd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A name for the Batch account which must be unique within the region. Batch account names must be between 3 and 24 characters in length and must use only numbers and lowercase letters. This name is used as part of the DNS name that is used to access the Batch service in the region in which the account is created. For example: http://accountname.region.batch.azure.com/.
     */
    @JvmName("msnoxgftdtadpqcw")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     */
    @JvmName("xdixixbklcmyqjac")
    public suspend fun allowedAuthenticationModes(`value`: List<AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAuthenticationModes = mapped
    }

    /**
     * @param values List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     */
    @JvmName("snietjjnqdetylvx")
    public suspend fun allowedAuthenticationModes(vararg values: AuthenticationMode) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAuthenticationModes = mapped
    }

    /**
     * @param value The properties related to the auto-storage account.
     */
    @JvmName("qfotlnudfwtlhemr")
    public suspend fun autoStorage(`value`: AutoStorageBasePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStorage = mapped
    }

    /**
     * @param argument The properties related to the auto-storage account.
     */
    @JvmName("rboukisputaferwm")
    public suspend
    fun autoStorage(argument: suspend AutoStorageBasePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoStorageBasePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoStorage = mapped
    }

    /**
     * @param value Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     */
    @JvmName("usiqfwihapsbvwpl")
    public suspend fun encryption(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     */
    @JvmName("bjkajgmrfshuibaf")
    public suspend fun encryption(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identity of the Batch account.
     */
    @JvmName("xbjxptgdkntanecw")
    public suspend fun identity(`value`: BatchAccountIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the Batch account.
     */
    @JvmName("uqhvoxvxvssmcmqe")
    public suspend fun identity(argument: suspend BatchAccountIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BatchAccountIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value A reference to the Azure key vault associated with the Batch account.
     */
    @JvmName("dbkgcbgyefkfdrxq")
    public suspend fun keyVaultReference(`value`: KeyVaultReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReference = mapped
    }

    /**
     * @param argument A reference to the Azure key vault associated with the Batch account.
     */
    @JvmName("vppdnogqvhtngnwq")
    public suspend fun keyVaultReference(argument: suspend KeyVaultReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultReference = mapped
    }

    /**
     * @param value The region in which to create the account.
     */
    @JvmName("pcfeyusalfxobcnh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network profile only takes effect when publicNetworkAccess is enabled.
     */
    @JvmName("ndijvxnoxbigfdmv")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The network profile only takes effect when publicNetworkAccess is enabled.
     */
    @JvmName("cbqdjmrpuswvibce")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService.
     */
    @JvmName("qitbwilcccahbmbf")
    public suspend fun poolAllocationMode(`value`: PoolAllocationMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolAllocationMode = mapped
    }

    /**
     * @param value If not specified, the default value is 'enabled'.
     */
    @JvmName("nmkisqworwoftevk")
    public suspend fun publicNetworkAccess(`value`: PublicNetworkAccessType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group that contains the Batch account.
     */
    @JvmName("ftofnvwgcbxwtyep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The user-specified tags associated with the account.
     */
    @JvmName("wmpweaugednvbjem")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The user-specified tags associated with the account.
     */
    @JvmName("xynaxhlhsxeihduk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BatchAccountArgs = BatchAccountArgs(
        accountName = accountName,
        allowedAuthenticationModes = allowedAuthenticationModes,
        autoStorage = autoStorage,
        encryption = encryption,
        identity = identity,
        keyVaultReference = keyVaultReference,
        location = location,
        networkProfile = networkProfile,
        poolAllocationMode = poolAllocationMode,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
