@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class DynamicVNetAssignmentScope(
    public val javaValue: com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope> {
    /**
     * No dynamic VNet assignment is enabled.
     */
    None(com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope.None),

    /**
     * Dynamic VNet assignment is done per-job. If this value is set, the network configuration subnet ID must also be set. This feature requires approval before use, please contact support
     */
    Job(com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope.Job),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.DynamicVNetAssignmentScope):
            DynamicVNetAssignmentScope =
            DynamicVNetAssignmentScope.values().first { it.javaValue == javaType }
    }
}
