@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The identity of the Batch account, if configured. This is used when the user specifies 'Microsoft.KeyVault' as their Batch account encryption configuration or when `ManagedIdentity` is selected as the auto-storage authentication mode.
 * @property type The type of identity used for the Batch account.
 * @property userAssignedIdentities The list of user identities associated with the Batch account.
 */
public data class BatchAccountIdentityArgs(
    public val type: Output<ResourceIdentityType>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs =
        com.pulumi.azurenative.batch.inputs.BatchAccountIdentityArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [BatchAccountIdentityArgs].
 */
@PulumiTagMarker
public class BatchAccountIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the Batch account.
     */
    @JvmName("jkjdwwhknifsjgot")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the Batch account.
     */
    @JvmName("spyjnmhsftljlakn")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("owkeytesnauaagjx")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user identities associated with the Batch account.
     */
    @JvmName("bkgarbetekapsrgf")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the Batch account.
     */
    @JvmName("ybwgibwjdgpxbqyj")
    public suspend fun type(`value`: ResourceIdentityType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the Batch account.
     */
    @JvmName("qcslbaqxgxxayxqt")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the Batch account.
     */
    @JvmName("jivbevdrhmjvucto")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): BatchAccountIdentityArgs = BatchAccountIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
