@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.CloudServiceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property osFamily Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
 * @property osVersion The default value is * which specifies the latest operating system version for the specified OS family.
 */
public data class CloudServiceConfigurationArgs(
    public val osFamily: Output<String>,
    public val osVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.CloudServiceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.CloudServiceConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.CloudServiceConfigurationArgs.builder()
            .osFamily(osFamily.applyValue({ args0 -> args0 }))
            .osVersion(osVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudServiceConfigurationArgs].
 */
@PulumiTagMarker
public class CloudServiceConfigurationArgsBuilder internal constructor() {
    private var osFamily: Output<String>? = null

    private var osVersion: Output<String>? = null

    /**
     * @param value Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
     */
    @JvmName("qbevbkwpjohjcefn")
    public suspend fun osFamily(`value`: Output<String>) {
        this.osFamily = value
    }

    /**
     * @param value The default value is * which specifies the latest operating system version for the specified OS family.
     */
    @JvmName("ikmhycmvuusghjwp")
    public suspend fun osVersion(`value`: Output<String>) {
        this.osVersion = value
    }

    /**
     * @param value Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
     */
    @JvmName("hjnspjvvwntmvhqa")
    public suspend fun osFamily(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osFamily = mapped
    }

    /**
     * @param value The default value is * which specifies the latest operating system version for the specified OS family.
     */
    @JvmName("unhonbjdqkwkcfev")
    public suspend fun osVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osVersion = mapped
    }

    internal fun build(): CloudServiceConfigurationArgs = CloudServiceConfigurationArgs(
        osFamily = osFamily ?: throw PulumiNullFieldException("osFamily"),
        osVersion = osVersion,
    )
}
