@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.EndpointAccessProfileArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.EndpointAccessDefaultAction
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network access profile for Batch endpoint.
 * @property defaultAction Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
 * @property ipRules Array of IP ranges to filter client IP address.
 */
public data class EndpointAccessProfileArgs(
    public val defaultAction: Output<EndpointAccessDefaultAction>,
    public val ipRules: Output<List<IPRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.EndpointAccessProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.EndpointAccessProfileArgs =
        com.pulumi.azurenative.batch.inputs.EndpointAccessProfileArgs.builder()
            .defaultAction(defaultAction.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointAccessProfileArgs].
 */
@PulumiTagMarker
public class EndpointAccessProfileArgsBuilder internal constructor() {
    private var defaultAction: Output<EndpointAccessDefaultAction>? = null

    private var ipRules: Output<List<IPRuleArgs>>? = null

    /**
     * @param value Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     */
    @JvmName("wypnsgqiujhmhnhg")
    public suspend fun defaultAction(`value`: Output<EndpointAccessDefaultAction>) {
        this.defaultAction = value
    }

    /**
     * @param value Array of IP ranges to filter client IP address.
     */
    @JvmName("wxgbajfbbcxtmccp")
    public suspend fun ipRules(`value`: Output<List<IPRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("swlchvtnnccsbjud")
    public suspend fun ipRules(vararg values: Output<IPRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values Array of IP ranges to filter client IP address.
     */
    @JvmName("dntdxkrqqadbhoaf")
    public suspend fun ipRules(values: List<Output<IPRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     */
    @JvmName("ekgmdycbdhomxvfg")
    public suspend fun defaultAction(`value`: EndpointAccessDefaultAction) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Array of IP ranges to filter client IP address.
     */
    @JvmName("dyjywmyllisfutbv")
    public suspend fun ipRules(`value`: List<IPRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument Array of IP ranges to filter client IP address.
     */
    @JvmName("buokgnpudeyfpmdc")
    public suspend fun ipRules(argument: List<suspend IPRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument Array of IP ranges to filter client IP address.
     */
    @JvmName("mcakiupwhfjbrixi")
    public suspend fun ipRules(vararg argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument Array of IP ranges to filter client IP address.
     */
    @JvmName("gxkrhithljhkjhrj")
    public suspend fun ipRules(argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values Array of IP ranges to filter client IP address.
     */
    @JvmName("hlvkyceowchmgufd")
    public suspend fun ipRules(vararg values: IPRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    internal fun build(): EndpointAccessProfileArgs = EndpointAccessProfileArgs(
        defaultAction = defaultAction ?: throw PulumiNullFieldException("defaultAction"),
        ipRules = ipRules,
    )
}
