@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.LinuxUserConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gid The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
 * @property sshPrivateKey The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
 * @property uid The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
 */
public data class LinuxUserConfigurationArgs(
    public val gid: Output<Int>? = null,
    public val sshPrivateKey: Output<String>? = null,
    public val uid: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.LinuxUserConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.LinuxUserConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.LinuxUserConfigurationArgs.builder()
            .gid(gid?.applyValue({ args0 -> args0 }))
            .sshPrivateKey(sshPrivateKey?.applyValue({ args0 -> args0 }))
            .uid(uid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxUserConfigurationArgs].
 */
@PulumiTagMarker
public class LinuxUserConfigurationArgsBuilder internal constructor() {
    private var gid: Output<Int>? = null

    private var sshPrivateKey: Output<String>? = null

    private var uid: Output<Int>? = null

    /**
     * @param value The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
     */
    @JvmName("yahkkaffmolmxcsm")
    public suspend fun gid(`value`: Output<Int>) {
        this.gid = value
    }

    /**
     * @param value The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
     */
    @JvmName("epqabfyminfewtmx")
    public suspend fun sshPrivateKey(`value`: Output<String>) {
        this.sshPrivateKey = value
    }

    /**
     * @param value The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
     */
    @JvmName("qnukdickwftcqqws")
    public suspend fun uid(`value`: Output<Int>) {
        this.uid = value
    }

    /**
     * @param value The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
     */
    @JvmName("xynipvrgmxekfauu")
    public suspend fun gid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gid = mapped
    }

    /**
     * @param value The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
     */
    @JvmName("degxmndsuygxclqa")
    public suspend fun sshPrivateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPrivateKey = mapped
    }

    /**
     * @param value The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
     */
    @JvmName("hyotyfhjfuejharb")
    public suspend fun uid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    internal fun build(): LinuxUserConfigurationArgs = LinuxUserConfigurationArgs(
        gid = gid,
        sshPrivateKey = sshPrivateKey,
        uid = uid,
    )
}
