@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.VirtualMachineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerConfiguration If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
 * @property dataDisks This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
 * @property diskEncryptionConfiguration If specified, encryption is performed on each node in the pool during node provisioning.
 * @property extensions If specified, the extensions mentioned in this configuration will be installed on each node.
 * @property imageReference
 * @property licenseType This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
 *  Windows_Server - The on-premises license is for Windows Server.
 *  Windows_Client - The on-premises license is for Windows Client.
 * @property nodeAgentSkuId The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
 * @property nodePlacementConfiguration This configuration will specify rules on how nodes in the pool will be physically allocated.
 * @property osDisk Contains configuration for ephemeral OSDisk settings.
 * @property windowsConfiguration This property must not be specified if the imageReference specifies a Linux OS image.
 */
public data class VirtualMachineConfigurationArgs(
    public val containerConfiguration: Output<ContainerConfigurationArgs>? = null,
    public val dataDisks: Output<List<DataDiskArgs>>? = null,
    public val diskEncryptionConfiguration: Output<DiskEncryptionConfigurationArgs>? = null,
    public val extensions: Output<List<VMExtensionArgs>>? = null,
    public val imageReference: Output<ImageReferenceArgs>,
    public val licenseType: Output<String>? = null,
    public val nodeAgentSkuId: Output<String>,
    public val nodePlacementConfiguration: Output<NodePlacementConfigurationArgs>? = null,
    public val osDisk: Output<OSDiskArgs>? = null,
    public val windowsConfiguration: Output<WindowsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.VirtualMachineConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.VirtualMachineConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.VirtualMachineConfigurationArgs.builder()
            .containerConfiguration(
                containerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .diskEncryptionConfiguration(
                diskEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageReference(imageReference.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .nodeAgentSkuId(nodeAgentSkuId.applyValue({ args0 -> args0 }))
            .nodePlacementConfiguration(
                nodePlacementConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineConfigurationArgsBuilder internal constructor() {
    private var containerConfiguration: Output<ContainerConfigurationArgs>? = null

    private var dataDisks: Output<List<DataDiskArgs>>? = null

    private var diskEncryptionConfiguration: Output<DiskEncryptionConfigurationArgs>? = null

    private var extensions: Output<List<VMExtensionArgs>>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var licenseType: Output<String>? = null

    private var nodeAgentSkuId: Output<String>? = null

    private var nodePlacementConfiguration: Output<NodePlacementConfigurationArgs>? = null

    private var osDisk: Output<OSDiskArgs>? = null

    private var windowsConfiguration: Output<WindowsConfigurationArgs>? = null

    /**
     * @param value If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
     */
    @JvmName("knxveriakpmxyxcd")
    public suspend fun containerConfiguration(`value`: Output<ContainerConfigurationArgs>) {
        this.containerConfiguration = value
    }

    /**
     * @param value This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("bmhjulbtpykhvyrs")
    public suspend fun dataDisks(`value`: Output<List<DataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("qgmhsxsrcojqnnel")
    public suspend fun dataDisks(vararg values: Output<DataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("hmpsiulrbqhrvevi")
    public suspend fun dataDisks(values: List<Output<DataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value If specified, encryption is performed on each node in the pool during node provisioning.
     */
    @JvmName("apteuamjsmkdgsxg")
    public suspend fun diskEncryptionConfiguration(`value`: Output<DiskEncryptionConfigurationArgs>) {
        this.diskEncryptionConfiguration = value
    }

    /**
     * @param value If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("homysaagrbqtehjw")
    public suspend fun extensions(`value`: Output<List<VMExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("gtmsmeucvivqsord")
    public suspend fun extensions(vararg values: Output<VMExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("bewiksveicvbkrql")
    public suspend fun extensions(values: List<Output<VMExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qlbnajcfcvojgrww")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
     *  Windows_Server - The on-premises license is for Windows Server.
     *  Windows_Client - The on-premises license is for Windows Client.
     */
    @JvmName("pswhgepkkeylikli")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
     */
    @JvmName("jyxwampaqlsevaqs")
    public suspend fun nodeAgentSkuId(`value`: Output<String>) {
        this.nodeAgentSkuId = value
    }

    /**
     * @param value This configuration will specify rules on how nodes in the pool will be physically allocated.
     */
    @JvmName("kqdhuojjhceuolqc")
    public suspend fun nodePlacementConfiguration(`value`: Output<NodePlacementConfigurationArgs>) {
        this.nodePlacementConfiguration = value
    }

    /**
     * @param value Contains configuration for ephemeral OSDisk settings.
     */
    @JvmName("onkxfadlduquxsoo")
    public suspend fun osDisk(`value`: Output<OSDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value This property must not be specified if the imageReference specifies a Linux OS image.
     */
    @JvmName("ejjkbdikfejkeuyu")
    public suspend fun windowsConfiguration(`value`: Output<WindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
     */
    @JvmName("duynxvxgqtnhrymh")
    public suspend fun containerConfiguration(`value`: ContainerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerConfiguration = mapped
    }

    /**
     * @param argument If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
     */
    @JvmName("hghvxuwdxuomttuy")
    public suspend
    fun containerConfiguration(argument: suspend ContainerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerConfiguration = mapped
    }

    /**
     * @param value This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("unsoilwpogjaaiob")
    public suspend fun dataDisks(`value`: List<DataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("xjlscupwdxexledk")
    public suspend fun dataDisks(argument: List<suspend DataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("foevymnksavwnbyp")
    public suspend fun dataDisks(vararg argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("bbypbpcjgeelgbyh")
    public suspend fun dataDisks(argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
     */
    @JvmName("qpdgmchahkvueixj")
    public suspend fun dataDisks(vararg values: DataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value If specified, encryption is performed on each node in the pool during node provisioning.
     */
    @JvmName("rapqxlqdyeydkasx")
    public suspend fun diskEncryptionConfiguration(`value`: DiskEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionConfiguration = mapped
    }

    /**
     * @param argument If specified, encryption is performed on each node in the pool during node provisioning.
     */
    @JvmName("ypwbuhkgwcabhoyb")
    public suspend
    fun diskEncryptionConfiguration(argument: suspend DiskEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionConfiguration = mapped
    }

    /**
     * @param value If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("rrdvupjwnjycccld")
    public suspend fun extensions(`value`: List<VMExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("gpopnetnbgrrjxhq")
    public suspend fun extensions(argument: List<suspend VMExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VMExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("nbpselasgsyfyhan")
    public suspend fun extensions(vararg argument: suspend VMExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VMExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("ymdvdhrsbcennpxb")
    public suspend fun extensions(argument: suspend VMExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VMExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values If specified, the extensions mentioned in this configuration will be installed on each node.
     */
    @JvmName("lwwkmjhaanhsenaw")
    public suspend fun extensions(vararg values: VMExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("ntowjwdpxbyclikr")
    public suspend fun imageReference(`value`: ImageReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument
     */
    @JvmName("knqkqhkeyuaboxgi")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
     *  Windows_Server - The on-premises license is for Windows Server.
     *  Windows_Client - The on-premises license is for Windows Client.
     */
    @JvmName("pmogbwapqklataxu")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
     */
    @JvmName("gssehcpqhxtbkcbk")
    public suspend fun nodeAgentSkuId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeAgentSkuId = mapped
    }

    /**
     * @param value This configuration will specify rules on how nodes in the pool will be physically allocated.
     */
    @JvmName("hqpnlhpvegtowayh")
    public suspend fun nodePlacementConfiguration(`value`: NodePlacementConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodePlacementConfiguration = mapped
    }

    /**
     * @param argument This configuration will specify rules on how nodes in the pool will be physically allocated.
     */
    @JvmName("iklqrylpokvlqjcr")
    public suspend
    fun nodePlacementConfiguration(argument: suspend NodePlacementConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NodePlacementConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodePlacementConfiguration = mapped
    }

    /**
     * @param value Contains configuration for ephemeral OSDisk settings.
     */
    @JvmName("pflmfqvnrmffekkb")
    public suspend fun osDisk(`value`: OSDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Contains configuration for ephemeral OSDisk settings.
     */
    @JvmName("vjmcmkrrdynangui")
    public suspend fun osDisk(argument: suspend OSDiskArgsBuilder.() -> Unit) {
        val toBeMapped = OSDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    /**
     * @param value This property must not be specified if the imageReference specifies a Linux OS image.
     */
    @JvmName("hffenebjyktyxerm")
    public suspend fun windowsConfiguration(`value`: WindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument This property must not be specified if the imageReference specifies a Linux OS image.
     */
    @JvmName("hrjwkbpbsflnqtmw")
    public suspend
    fun windowsConfiguration(argument: suspend WindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): VirtualMachineConfigurationArgs = VirtualMachineConfigurationArgs(
        containerConfiguration = containerConfiguration,
        dataDisks = dataDisks,
        diskEncryptionConfiguration = diskEncryptionConfiguration,
        extensions = extensions,
        imageReference = imageReference ?: throw PulumiNullFieldException("imageReference"),
        licenseType = licenseType,
        nodeAgentSkuId = nodeAgentSkuId ?: throw PulumiNullFieldException("nodeAgentSkuId"),
        nodePlacementConfiguration = nodePlacementConfiguration,
        osDisk = osDisk,
        windowsConfiguration = windowsConfiguration,
    )
}
