@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountKey This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
 * @property accountName
 * @property blobfuseOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property containerName
 * @property identityReference This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property sasKey This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
 */
public data class AzureBlobFileSystemConfigurationResponse(
    public val accountKey: String? = null,
    public val accountName: String,
    public val blobfuseOptions: String? = null,
    public val containerName: String,
    public val identityReference: ComputeNodeIdentityReferenceResponse? = null,
    public val relativeMountPath: String,
    public val sasKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AzureBlobFileSystemConfigurationResponse):
            AzureBlobFileSystemConfigurationResponse = AzureBlobFileSystemConfigurationResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName(),
            blobfuseOptions = javaType.blobfuseOptions().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName(),
            identityReference = javaType.identityReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ComputeNodeIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            relativeMountPath = javaType.relativeMountPath(),
            sasKey = javaType.sasKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
