@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities
 * @property type The type of identity used for the Batch Pool.
 * @property userAssignedIdentities The list of user identities associated with the Batch pool.
 */
public data class BatchPoolIdentityResponse(
    public val type: String,
    public val userAssignedIdentities: Map<String, UserAssignedIdentitiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.BatchPoolIdentityResponse):
            BatchPoolIdentityResponse = BatchPoolIdentityResponse(
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.UserAssignedIdentitiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
