@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An application package which represents a particular version of an application.
 * @property etag The ETag of the resource, used for concurrency statements.
 * @property format The format of the application package, if the package is active.
 * @property id The ID of the resource.
 * @property lastActivationTime The time at which the package was last activated, if the package is active.
 * @property name The name of the resource.
 * @property state The current state of the application package.
 * @property storageUrl The URL for the application package in Azure Storage.
 * @property storageUrlExpiry The UTC time at which the Azure Storage URL will expire.
 * @property type The type of the resource.
 */
public data class GetApplicationPackageResult(
    public val etag: String,
    public val format: String,
    public val id: String,
    public val lastActivationTime: String,
    public val name: String,
    public val state: String,
    public val storageUrl: String,
    public val storageUrlExpiry: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.GetApplicationPackageResult):
            GetApplicationPackageResult = GetApplicationPackageResult(
            etag = javaType.etag(),
            format = javaType.format(),
            id = javaType.id(),
            lastActivationTime = javaType.lastActivationTime(),
            name = javaType.name(),
            state = javaType.state(),
            storageUrl = javaType.storageUrl(),
            storageUrlExpiry = javaType.storageUrlExpiry(),
            type = javaType.type(),
        )
    }
}
