@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains information about a pool.
 * @property allocationState
 * @property allocationStateTransitionTime
 * @property applicationLicenses The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
 * @property applicationPackages Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
 * @property autoScaleRun This property is set only if the pool automatically scales, i.e. autoScaleSettings are used.
 * @property certificates For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
 * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
 * @property creationTime
 * @property currentDedicatedNodes
 * @property currentLowPriorityNodes
 * @property currentNodeCommunicationMode
 * @property deploymentConfiguration Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
 * @property displayName The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
 * @property etag The ETag of the resource, used for concurrency statements.
 * @property id The ID of the resource.
 * @property identity The type of identity used for the Batch Pool.
 * @property interNodeCommunication This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'.
 * @property lastModified This is the last time at which the pool level data, such as the targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes such as a compute node changing state.
 * @property metadata The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
 * @property mountConfiguration This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
 * @property name The name of the resource.
 * @property networkConfiguration The network configuration for a pool.
 * @property provisioningState
 * @property provisioningStateTransitionTime
 * @property resizeOperationStatus Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
 * @property scaleSettings Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 * @property startTask In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
 * @property targetNodeCommunicationMode If omitted, the default value is Default.
 * @property taskSchedulingPolicy If not specified, the default is spread.
 * @property taskSlotsPerNode The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256.
 * @property type The type of the resource.
 * @property userAccounts
 * @property vmSize For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
 */
public data class GetPoolResult(
    public val allocationState: String,
    public val allocationStateTransitionTime: String,
    public val applicationLicenses: List<String>? = null,
    public val applicationPackages: List<ApplicationPackageReferenceResponse>? = null,
    public val autoScaleRun: AutoScaleRunResponse,
    public val certificates: List<CertificateReferenceResponse>? = null,
    public val creationTime: String,
    public val currentDedicatedNodes: Int,
    public val currentLowPriorityNodes: Int,
    public val currentNodeCommunicationMode: String,
    public val deploymentConfiguration: DeploymentConfigurationResponse? = null,
    public val displayName: String? = null,
    public val etag: String,
    public val id: String,
    public val identity: BatchPoolIdentityResponse? = null,
    public val interNodeCommunication: String? = null,
    public val lastModified: String,
    public val metadata: List<MetadataItemResponse>? = null,
    public val mountConfiguration: List<MountConfigurationResponse>? = null,
    public val name: String,
    public val networkConfiguration: NetworkConfigurationResponse? = null,
    public val provisioningState: String,
    public val provisioningStateTransitionTime: String,
    public val resizeOperationStatus: ResizeOperationStatusResponse,
    public val scaleSettings: ScaleSettingsResponse? = null,
    public val startTask: StartTaskResponse? = null,
    public val targetNodeCommunicationMode: String? = null,
    public val taskSchedulingPolicy: TaskSchedulingPolicyResponse? = null,
    public val taskSlotsPerNode: Int? = null,
    public val type: String,
    public val userAccounts: List<UserAccountResponse>? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.GetPoolResult): GetPoolResult =
            GetPoolResult(
                allocationState = javaType.allocationState(),
                allocationStateTransitionTime = javaType.allocationStateTransitionTime(),
                applicationLicenses = javaType.applicationLicenses().map({ args0 -> args0 }),
                applicationPackages = javaType.applicationPackages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.ApplicationPackageReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
                autoScaleRun = javaType.autoScaleRun().let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AutoScaleRunResponse.Companion.toKotlin(args0)
                }),
                certificates = javaType.certificates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.CertificateReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
                creationTime = javaType.creationTime(),
                currentDedicatedNodes = javaType.currentDedicatedNodes(),
                currentLowPriorityNodes = javaType.currentLowPriorityNodes(),
                currentNodeCommunicationMode = javaType.currentNodeCommunicationMode(),
                deploymentConfiguration = javaType.deploymentConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.DeploymentConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id(),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.BatchPoolIdentityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                interNodeCommunication = javaType.interNodeCommunication().map({ args0 -> args0 }).orElse(null),
                lastModified = javaType.lastModified(),
                metadata = javaType.metadata().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.MetadataItemResponse.Companion.toKotlin(args0)
                    })
                }),
                mountConfiguration = javaType.mountConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.MountConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                provisioningStateTransitionTime = javaType.provisioningStateTransitionTime(),
                resizeOperationStatus = javaType.resizeOperationStatus().let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ResizeOperationStatusResponse.Companion.toKotlin(args0)
                }),
                scaleSettings = javaType.scaleSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.ScaleSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                startTask = javaType.startTask().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.StartTaskResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                targetNodeCommunicationMode = javaType.targetNodeCommunicationMode().map({ args0 ->
                    args0
                }).orElse(null),
                taskSchedulingPolicy = javaType.taskSchedulingPolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.TaskSchedulingPolicyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                taskSlotsPerNode = javaType.taskSlotsPerNode().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
                userAccounts = javaType.userAccounts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.batch.kotlin.outputs.UserAccountResponse.Companion.toKotlin(args0)
                    })
                }),
                vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
