@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identifies the Azure key vault associated with a Batch account.
 * @property id The resource ID of the Azure key vault associated with the Batch account.
 * @property url The URL of the Azure key vault associated with the Batch account.
 */
public data class KeyVaultReferenceResponse(
    public val id: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.KeyVaultReferenceResponse):
            KeyVaultReferenceResponse = KeyVaultReferenceResponse(
            id = javaType.id(),
            url = javaType.url(),
        )
    }
}
