@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property gid The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
 * @property sshPrivateKey The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
 * @property uid The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
 */
public data class LinuxUserConfigurationResponse(
    public val gid: Int? = null,
    public val sshPrivateKey: String? = null,
    public val uid: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.LinuxUserConfigurationResponse):
            LinuxUserConfigurationResponse = LinuxUserConfigurationResponse(
            gid = javaType.gid().map({ args0 -> args0 }).orElse(null),
            sshPrivateKey = javaType.sshPrivateKey().map({ args0 -> args0 }).orElse(null),
            uid = javaType.uid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
