@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property azureBlobFileSystemConfiguration This property is mutually exclusive with all other properties.
 * @property azureFileShareConfiguration This property is mutually exclusive with all other properties.
 * @property cifsMountConfiguration This property is mutually exclusive with all other properties.
 * @property nfsMountConfiguration This property is mutually exclusive with all other properties.
 */
public data class MountConfigurationResponse(
    public val azureBlobFileSystemConfiguration: AzureBlobFileSystemConfigurationResponse? = null,
    public val azureFileShareConfiguration: AzureFileShareConfigurationResponse? = null,
    public val cifsMountConfiguration: CIFSMountConfigurationResponse? = null,
    public val nfsMountConfiguration: NFSMountConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.MountConfigurationResponse):
            MountConfigurationResponse = MountConfigurationResponse(
            azureBlobFileSystemConfiguration = javaType.azureBlobFileSystemConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AzureBlobFileSystemConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureFileShareConfiguration = javaType.azureFileShareConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AzureFileShareConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cifsMountConfiguration = javaType.cifsMountConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.CIFSMountConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nfsMountConfiguration = javaType.nfsMountConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.NFSMountConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
