@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property access
 * @property priority Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
 * @property sourceAddressPrefix Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
 * @property sourcePortRanges Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
 */
public data class NetworkSecurityGroupRuleResponse(
    public val access: String,
    public val priority: Int,
    public val sourceAddressPrefix: String,
    public val sourcePortRanges: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.NetworkSecurityGroupRuleResponse):
            NetworkSecurityGroupRuleResponse = NetworkSecurityGroupRuleResponse(
            access = javaType.access(),
            priority = javaType.priority(),
            sourceAddressPrefix = javaType.sourceAddressPrefix(),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
        )
    }
}
