@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoStorageContainerName The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
 * @property blobPrefix The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
 * @property fileMode This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
 * @property filePath If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
 * @property httpUrl The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, use a managed identity with read permission, or set the ACL for the blob or its container to allow public access.
 * @property identityReference The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property storageContainerUrl The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable from compute nodes. There are three ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, use a managed identity with read and list permissions, or set the ACL for the container to allow public access.
 */
public data class ResourceFileResponse(
    public val autoStorageContainerName: String? = null,
    public val blobPrefix: String? = null,
    public val fileMode: String? = null,
    public val filePath: String? = null,
    public val httpUrl: String? = null,
    public val identityReference: ComputeNodeIdentityReferenceResponse? = null,
    public val storageContainerUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ResourceFileResponse):
            ResourceFileResponse = ResourceFileResponse(
            autoStorageContainerName = javaType.autoStorageContainerName().map({ args0 -> args0 }).orElse(null),
            blobPrefix = javaType.blobPrefix().map({ args0 -> args0 }).orElse(null),
            fileMode = javaType.fileMode().map({ args0 -> args0 }).orElse(null),
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            httpUrl = javaType.httpUrl().map({ args0 -> args0 }).orElse(null),
            identityReference = javaType.identityReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ComputeNodeIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageContainerUrl = javaType.storageContainerUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
