@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property name
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher
 * @property settings
 * @property type
 * @property typeHandlerVersion
 */
public data class VMExtensionResponse(
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val enableAutomaticUpgrade: Boolean? = null,
    public val name: String,
    public val protectedSettings: Any? = null,
    public val provisionAfterExtensions: List<String>? = null,
    public val publisher: String,
    public val settings: Any? = null,
    public val type: String,
    public val typeHandlerVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.VMExtensionResponse):
            VMExtensionResponse = VMExtensionResponse(
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            enableAutomaticUpgrade = javaType.enableAutomaticUpgrade().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            provisionAfterExtensions = javaType.provisionAfterExtensions().map({ args0 -> args0 }),
            publisher = javaType.publisher(),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            typeHandlerVersion = javaType.typeHandlerVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
