@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BillingRoleAssignmentByDepartment].
 */
@PulumiTagMarker
public class BillingRoleAssignmentByDepartmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BillingRoleAssignmentByDepartmentArgs = BillingRoleAssignmentByDepartmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BillingRoleAssignmentByDepartmentArgsBuilder.() -> Unit) {
        val builder = BillingRoleAssignmentByDepartmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BillingRoleAssignmentByDepartment {
        val builtJavaResource =
            com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BillingRoleAssignmentByDepartment(builtJavaResource)
    }
}

/**
 * The role assignment
 * Azure REST API version: 2019-10-01-preview. Prior API version in Azure Native 1.x: 2019-10-01-preview.
 * ## Example Usage
 * ### PutEnrollmentDepartmentAdministratorRoleAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var billingRoleAssignmentByDepartment = new AzureNative.Billing.BillingRoleAssignmentByDepartment("billingRoleAssignmentByDepartment", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingRoleAssignmentName = "{billingRoleAssignmentName}",
 *         DepartmentName = "{departmentName}",
 *         PrincipalId = "99a1a759-30dd-42c2-828c-db398826bb67",
 *         PrincipalTenantId = "7ca289b9-c32d-4f01-8566-7ff93261d76f",
 *         RoleDefinitionId = "/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/billing/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := billing.NewBillingRoleAssignmentByDepartment(ctx, "billingRoleAssignmentByDepartment", &billing.BillingRoleAssignmentByDepartmentArgs{
 * 			BillingAccountName:        pulumi.String("{billingAccountName}"),
 * 			BillingRoleAssignmentName: pulumi.String("{billingRoleAssignmentName}"),
 * 			DepartmentName:            pulumi.String("{departmentName}"),
 * 			PrincipalId:               pulumi.String("99a1a759-30dd-42c2-828c-db398826bb67"),
 * 			PrincipalTenantId:         pulumi.String("7ca289b9-c32d-4f01-8566-7ff93261d76f"),
 * 			RoleDefinitionId:          pulumi.String("/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var billingRoleAssignmentByDepartment = new BillingRoleAssignmentByDepartment("billingRoleAssignmentByDepartment", BillingRoleAssignmentByDepartmentArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingRoleAssignmentName("{billingRoleAssignmentName}")
 *             .departmentName("{departmentName}")
 *             .principalId("99a1a759-30dd-42c2-828c-db398826bb67")
 *             .principalTenantId("7ca289b9-c32d-4f01-8566-7ff93261d76f")
 *             .roleDefinitionId("/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:billing:BillingRoleAssignmentByDepartment 9dfd08c2-62a3-4d47-85bd-1cdba1408402 /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/billingRoleAssignments/{billingRoleAssignmentName}
 * ```
 */
public class BillingRoleAssignmentByDepartment internal constructor(
    override val javaResource: com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment,
) : KotlinCustomResource(javaResource, BillingRoleAssignmentByDepartmentMapper) {
    /**
     * The principal Id of the user who created the role assignment.
     */
    public val createdByPrincipalId: Output<String>
        get() = javaResource.createdByPrincipalId().applyValue({ args0 -> args0 })

    /**
     * The tenant Id of the user who created the role assignment.
     */
    public val createdByPrincipalTenantId: Output<String>
        get() = javaResource.createdByPrincipalTenantId().applyValue({ args0 -> args0 })

    /**
     * The email address of the user who created the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val createdByUserEmailAddress: Output<String>
        get() = javaResource.createdByUserEmailAddress().applyValue({ args0 -> args0 })

    /**
     * The date the role assignment was created.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal id of the user to whom the role was assigned.
     */
    public val principalId: Output<String>?
        get() = javaResource.principalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The principal tenant id of the user to whom the role was assigned.
     */
    public val principalTenantId: Output<String>?
        get() = javaResource.principalTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the role definition.
     */
    public val roleDefinitionId: Output<String>?
        get() = javaResource.roleDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The scope at which the role was assigned.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val userAuthenticationType: Output<String>?
        get() = javaResource.userAuthenticationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val userEmailAddress: Output<String>?
        get() = javaResource.userEmailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BillingRoleAssignmentByDepartmentMapper :
    ResourceMapper<BillingRoleAssignmentByDepartment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment::class == javaResource::class

    override fun map(javaResource: Resource): BillingRoleAssignmentByDepartment =
        BillingRoleAssignmentByDepartment(
            javaResource as
                com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment,
        )
}

/**
 * @see [BillingRoleAssignmentByDepartment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BillingRoleAssignmentByDepartment].
 */
public suspend fun billingRoleAssignmentByDepartment(
    name: String,
    block: suspend BillingRoleAssignmentByDepartmentResourceBuilder.() -> Unit,
):
    BillingRoleAssignmentByDepartment {
    val builder = BillingRoleAssignmentByDepartmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BillingRoleAssignmentByDepartment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun billingRoleAssignmentByDepartment(name: String): BillingRoleAssignmentByDepartment {
    val builder = BillingRoleAssignmentByDepartmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
