@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BillingRoleAssignmentByEnrollmentAccount].
 */
@PulumiTagMarker
public class BillingRoleAssignmentByEnrollmentAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BillingRoleAssignmentByEnrollmentAccountArgs =
        BillingRoleAssignmentByEnrollmentAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend BillingRoleAssignmentByEnrollmentAccountArgsBuilder.() -> Unit) {
        val builder = BillingRoleAssignmentByEnrollmentAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BillingRoleAssignmentByEnrollmentAccount {
        val builtJavaResource =
            com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BillingRoleAssignmentByEnrollmentAccount(builtJavaResource)
    }
}

/**
 * The role assignment
 * Azure REST API version: 2019-10-01-preview. Prior API version in Azure Native 1.x: 2019-10-01-preview.
 * ## Example Usage
 * ### PutEnrollmentAccountSubscriptionCreatorRoleAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var billingRoleAssignmentByEnrollmentAccount = new AzureNative.Billing.BillingRoleAssignmentByEnrollmentAccount("billingRoleAssignmentByEnrollmentAccount", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingRoleAssignmentName = "{billingRoleAssignmentName}",
 *         EnrollmentAccountName = "{enrollmentAccountName}",
 *         PrincipalId = "99a1a759-30dd-42c2-828c-db398826bb67",
 *         PrincipalTenantId = "7ca289b9-c32d-4f01-8566-7ff93261d76f",
 *         RoleDefinitionId = "/providers/Microsoft.Billing/billingAccounts/7898901/enrollmentAccounts/225314/billingRoleDefinitions/a0bcee42-bf30-4d1b-926a-48d21664ef71",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/billing/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := billing.NewBillingRoleAssignmentByEnrollmentAccount(ctx, "billingRoleAssignmentByEnrollmentAccount", &billing.BillingRoleAssignmentByEnrollmentAccountArgs{
 * 			BillingAccountName:        pulumi.String("{billingAccountName}"),
 * 			BillingRoleAssignmentName: pulumi.String("{billingRoleAssignmentName}"),
 * 			EnrollmentAccountName:     pulumi.String("{enrollmentAccountName}"),
 * 			PrincipalId:               pulumi.String("99a1a759-30dd-42c2-828c-db398826bb67"),
 * 			PrincipalTenantId:         pulumi.String("7ca289b9-c32d-4f01-8566-7ff93261d76f"),
 * 			RoleDefinitionId:          pulumi.String("/providers/Microsoft.Billing/billingAccounts/7898901/enrollmentAccounts/225314/billingRoleDefinitions/a0bcee42-bf30-4d1b-926a-48d21664ef71"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccount;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var billingRoleAssignmentByEnrollmentAccount = new BillingRoleAssignmentByEnrollmentAccount("billingRoleAssignmentByEnrollmentAccount", BillingRoleAssignmentByEnrollmentAccountArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingRoleAssignmentName("{billingRoleAssignmentName}")
 *             .enrollmentAccountName("{enrollmentAccountName}")
 *             .principalId("99a1a759-30dd-42c2-828c-db398826bb67")
 *             .principalTenantId("7ca289b9-c32d-4f01-8566-7ff93261d76f")
 *             .roleDefinitionId("/providers/Microsoft.Billing/billingAccounts/7898901/enrollmentAccounts/225314/billingRoleDefinitions/a0bcee42-bf30-4d1b-926a-48d21664ef71")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:billing:BillingRoleAssignmentByEnrollmentAccount 9dfd08c2-62a3-4d47-85bd-1cdba1408402 /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}/billingRoleAssignments/{billingRoleAssignmentName}
 * ```
 */
public class BillingRoleAssignmentByEnrollmentAccount internal constructor(
    override val javaResource:
    com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccount,
) : KotlinCustomResource(javaResource, BillingRoleAssignmentByEnrollmentAccountMapper) {
    /**
     * The principal Id of the user who created the role assignment.
     */
    public val createdByPrincipalId: Output<String>
        get() = javaResource.createdByPrincipalId().applyValue({ args0 -> args0 })

    /**
     * The tenant Id of the user who created the role assignment.
     */
    public val createdByPrincipalTenantId: Output<String>
        get() = javaResource.createdByPrincipalTenantId().applyValue({ args0 -> args0 })

    /**
     * The email address of the user who created the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val createdByUserEmailAddress: Output<String>
        get() = javaResource.createdByUserEmailAddress().applyValue({ args0 -> args0 })

    /**
     * The date the role assignment was created.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal id of the user to whom the role was assigned.
     */
    public val principalId: Output<String>?
        get() = javaResource.principalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The principal tenant id of the user to whom the role was assigned.
     */
    public val principalTenantId: Output<String>?
        get() = javaResource.principalTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the role definition.
     */
    public val roleDefinitionId: Output<String>?
        get() = javaResource.roleDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The scope at which the role was assigned.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val userAuthenticationType: Output<String>?
        get() = javaResource.userAuthenticationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    public val userEmailAddress: Output<String>?
        get() = javaResource.userEmailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BillingRoleAssignmentByEnrollmentAccountMapper :
    ResourceMapper<BillingRoleAssignmentByEnrollmentAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccount::class == javaResource::class

    override fun map(javaResource: Resource): BillingRoleAssignmentByEnrollmentAccount =
        BillingRoleAssignmentByEnrollmentAccount(
            javaResource as
                com.pulumi.azurenative.billing.BillingRoleAssignmentByEnrollmentAccount,
        )
}

/**
 * @see [BillingRoleAssignmentByEnrollmentAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BillingRoleAssignmentByEnrollmentAccount].
 */
public suspend fun billingRoleAssignmentByEnrollmentAccount(
    name: String,
    block: suspend BillingRoleAssignmentByEnrollmentAccountResourceBuilder.() -> Unit,
):
    BillingRoleAssignmentByEnrollmentAccount {
    val builder = BillingRoleAssignmentByEnrollmentAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BillingRoleAssignmentByEnrollmentAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun billingRoleAssignmentByEnrollmentAccount(name: String):
    BillingRoleAssignmentByEnrollmentAccount {
    val builder = BillingRoleAssignmentByEnrollmentAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
