@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.inputs

import com.pulumi.azurenative.billing.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 */
public data class ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs(
    public val billingAccountName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.billing.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.billing.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs =
        com.pulumi.azurenative.billing.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs].
 */
@PulumiTagMarker
public class ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgsBuilder
internal constructor() {
    private var billingAccountName: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("kktpqufdmfduwhja")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    internal fun build(): ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs =
        ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs(
            billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
        )
}
