@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.ListTransactionNodeApiKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockchainMemberName Blockchain member name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property transactionNodeName Transaction node name.
 */
public data class ListTransactionNodeApiKeysPlainArgs(
    public val blockchainMemberName: String,
    public val resourceGroupName: String,
    public val transactionNodeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.ListTransactionNodeApiKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.blockchain.inputs.ListTransactionNodeApiKeysPlainArgs =
        com.pulumi.azurenative.blockchain.inputs.ListTransactionNodeApiKeysPlainArgs.builder()
            .blockchainMemberName(blockchainMemberName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .transactionNodeName(transactionNodeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListTransactionNodeApiKeysPlainArgs].
 */
@PulumiTagMarker
public class ListTransactionNodeApiKeysPlainArgsBuilder internal constructor() {
    private var blockchainMemberName: String? = null

    private var resourceGroupName: String? = null

    private var transactionNodeName: String? = null

    /**
     * @param value Blockchain member name.
     */
    @JvmName("lfejruroyfwwijyl")
    public suspend fun blockchainMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blockchainMemberName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ikrqjxhypcdbxgtg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Transaction node name.
     */
    @JvmName("sairxeshtpsacsii")
    public suspend fun transactionNodeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transactionNodeName = mapped
    }

    internal fun build(): ListTransactionNodeApiKeysPlainArgs = ListTransactionNodeApiKeysPlainArgs(
        blockchainMemberName = blockchainMemberName ?: throw
            PulumiNullFieldException("blockchainMemberName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        transactionNodeName = transactionNodeName ?: throw PulumiNullFieldException("transactionNodeName"),
    )
}
