@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Blockchain member Sku in payload
 * @property name Gets or sets Sku name
 * @property tier Gets or sets Sku tier
 */
public data class SkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
