@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [TemplateArtifact].
 */
@PulumiTagMarker
public class TemplateArtifactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArtifactArgs = TemplateArtifactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArtifactArgsBuilder.() -> Unit) {
        val builder = TemplateArtifactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TemplateArtifact {
        val builtJavaResource =
            com.pulumi.azurenative.blueprint.TemplateArtifact(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TemplateArtifact(builtJavaResource)
    }
}

/**
 * Blueprint artifact that deploys a Resource Manager template.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         Kind = "template",
 *         Parameters =
 *         {
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameters('storageAccountType')]",
 *             } },
 *         },
 *         ResourceGroup = "storageRG",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         Template = new Dictionary<string, object?>
 *         {
 *             ["contentVersion"] = "1.0.0.0",
 *             ["outputs"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountName"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "string",
 *                     ["value"] = "[variables('storageAccountName')]",
 *                 },
 *             },
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountType"] = new Dictionary<string, object?>
 *                 {
 *                     ["allowedValues"] = new[]
 *                     {
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS",
 *                     },
 *                     ["defaultValue"] = "Standard_LRS",
 *                     ["metadata"] = new Dictionary<string, object?>
 *                     {
 *                         ["description"] = "Storage Account type",
 *                     },
 *                     ["type"] = "string",
 *                 },
 *             },
 *             ["resources"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["apiVersion"] = "2016-01-01",
 *                     ["kind"] = "Storage",
 *                     ["location"] = "[resourceGroup().location]",
 *                     ["name"] = "[variables('storageAccountName')]",
 *                     ["properties"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["sku"] = new Dictionary<string, object?>
 *                     {
 *                         ["name"] = "[parameters('storageAccountType')]",
 *                     },
 *                     ["type"] = "Microsoft.Storage/storageAccounts",
 *                 },
 *             },
 *             ["variables"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Kind:          pulumi.String("template"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameters('storageAccountType')]"),
 * 				},
 * 			},
 * 			ResourceGroup: pulumi.String("storageRG"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			Template: pulumi.Any(map[string]interface{}{
 * 				"contentVersion": "1.0.0.0",
 * 				"outputs": map[string]interface{}{
 * 					"storageAccountName": map[string]interface{}{
 * 						"type":  "string",
 * 						"value": "[variables('storageAccountName')]",
 * 					},
 * 				},
 * 				"parameters": map[string]interface{}{
 * 					"storageAccountType": map[string]interface{}{
 * 						"allowedValues": []string{
 * 							"Standard_LRS",
 * 							"Standard_GRS",
 * 							"Standard_ZRS",
 * 							"Premium_LRS",
 * 						},
 * 						"defaultValue": "Standard_LRS",
 * 						"metadata": map[string]interface{}{
 * 							"description": "Storage Account type",
 * 						},
 * 						"type": "string",
 * 					},
 * 				},
 * 				"resources": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2016-01-01",
 * 						"kind":       "Storage",
 * 						"location":   "[resourceGroup().location]",
 * 						"name":       "[variables('storageAccountName')]",
 * 						"properties": nil,
 * 						"sku": map[string]interface{}{
 * 							"name": "[parameters('storageAccountType')]",
 * 						},
 * 						"type": "Microsoft.Storage/storageAccounts",
 * 					},
 * 				},
 * 				"variables": map[string]interface{}{
 * 					"storageAccountName": "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .kind("template")
 *             .parameters(Map.of("storageAccountType", Map.of("value", "[parameters('storageAccountType')]")))
 *             .resourceGroup("storageRG")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .template(Map.ofEntries(
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", Map.of("storageAccountName", Map.ofEntries(
 *                     Map.entry("type", "string"),
 *                     Map.entry("value", "[variables('storageAccountName')]")
 *                 ))),
 *                 Map.entry("parameters", Map.of("storageAccountType", Map.ofEntries(
 *                     Map.entry("allowedValues",
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS"),
 *                     Map.entry("defaultValue", "Standard_LRS"),
 *                     Map.entry("metadata", Map.of("description", "Storage Account type")),
 *                     Map.entry("type", "string")
 *                 ))),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("apiVersion", "2016-01-01"),
 *                     Map.entry("kind", "Storage"),
 *                     Map.entry("location", "[resourceGroup().location]"),
 *                     Map.entry("name", "[variables('storageAccountName')]"),
 *                     Map.entry("properties", ),
 *                     Map.entry("sku", Map.of("name", "[parameters('storageAccountType')]")),
 *                     Map.entry("type", "Microsoft.Storage/storageAccounts")
 *                 )),
 *                 Map.entry("variables", Map.of("storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         Kind = "template",
 *         Parameters =
 *         {
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameters('storageAccountType')]",
 *             } },
 *         },
 *         ResourceGroup = "storageRG",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Template = new Dictionary<string, object?>
 *         {
 *             ["contentVersion"] = "1.0.0.0",
 *             ["outputs"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountName"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "string",
 *                     ["value"] = "[variables('storageAccountName')]",
 *                 },
 *             },
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountType"] = new Dictionary<string, object?>
 *                 {
 *                     ["allowedValues"] = new[]
 *                     {
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS",
 *                     },
 *                     ["defaultValue"] = "Standard_LRS",
 *                     ["metadata"] = new Dictionary<string, object?>
 *                     {
 *                         ["description"] = "Storage Account type",
 *                     },
 *                     ["type"] = "string",
 *                 },
 *             },
 *             ["resources"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["apiVersion"] = "2016-01-01",
 *                     ["kind"] = "Storage",
 *                     ["location"] = "[resourceGroup().location]",
 *                     ["name"] = "[variables('storageAccountName')]",
 *                     ["properties"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["sku"] = new Dictionary<string, object?>
 *                     {
 *                         ["name"] = "[parameters('storageAccountType')]",
 *                     },
 *                     ["type"] = "Microsoft.Storage/storageAccounts",
 *                 },
 *             },
 *             ["variables"] = new Dictionary<string, object?>
 *             {
 *                 ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Kind:          pulumi.String("template"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameters('storageAccountType')]"),
 * 				},
 * 			},
 * 			ResourceGroup: pulumi.String("storageRG"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Template: pulumi.Any(map[string]interface{}{
 * 				"contentVersion": "1.0.0.0",
 * 				"outputs": map[string]interface{}{
 * 					"storageAccountName": map[string]interface{}{
 * 						"type":  "string",
 * 						"value": "[variables('storageAccountName')]",
 * 					},
 * 				},
 * 				"parameters": map[string]interface{}{
 * 					"storageAccountType": map[string]interface{}{
 * 						"allowedValues": []string{
 * 							"Standard_LRS",
 * 							"Standard_GRS",
 * 							"Standard_ZRS",
 * 							"Premium_LRS",
 * 						},
 * 						"defaultValue": "Standard_LRS",
 * 						"metadata": map[string]interface{}{
 * 							"description": "Storage Account type",
 * 						},
 * 						"type": "string",
 * 					},
 * 				},
 * 				"resources": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2016-01-01",
 * 						"kind":       "Storage",
 * 						"location":   "[resourceGroup().location]",
 * 						"name":       "[variables('storageAccountName')]",
 * 						"properties": nil,
 * 						"sku": map[string]interface{}{
 * 							"name": "[parameters('storageAccountType')]",
 * 						},
 * 						"type": "Microsoft.Storage/storageAccounts",
 * 					},
 * 				},
 * 				"variables": map[string]interface{}{
 * 					"storageAccountName": "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .kind("template")
 *             .parameters(Map.of("storageAccountType", Map.of("value", "[parameters('storageAccountType')]")))
 *             .resourceGroup("storageRG")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .template(Map.ofEntries(
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", Map.of("storageAccountName", Map.ofEntries(
 *                     Map.entry("type", "string"),
 *                     Map.entry("value", "[variables('storageAccountName')]")
 *                 ))),
 *                 Map.entry("parameters", Map.of("storageAccountType", Map.ofEntries(
 *                     Map.entry("allowedValues",
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS"),
 *                     Map.entry("defaultValue", "Standard_LRS"),
 *                     Map.entry("metadata", Map.of("description", "Storage Account type")),
 *                     Map.entry("type", "string")
 *                 ))),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("apiVersion", "2016-01-01"),
 *                     Map.entry("kind", "Storage"),
 *                     Map.entry("location", "[resourceGroup().location]"),
 *                     Map.entry("name", "[variables('storageAccountName')]"),
 *                     Map.entry("properties", ),
 *                     Map.entry("sku", Map.of("name", "[parameters('storageAccountType')]")),
 *                     Map.entry("type", "Microsoft.Storage/storageAccounts")
 *                 )),
 *                 Map.entry("variables", Map.of("storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:TemplateArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 */
public class TemplateArtifact internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.TemplateArtifact,
) : KotlinCustomResource(javaResource, TemplateArtifactMapper) {
    /**
     * Artifacts which need to be deployed before the specified artifact.
     */
    public val dependsOn: Output<List<String>>?
        get() = javaResource.dependsOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the kind of blueprint artifact.
     * Expected value is 'template'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource Manager template blueprint artifact parameter values.
     */
    public val parameters: Output<Map<String, ParameterValueResponse>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
     */
    public val resourceGroup: Output<String>?
        get() = javaResource.resourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Resource Manager template blueprint artifact body.
     */
    public val template: Output<Any>
        get() = javaResource.template().applyValue({ args0 -> args0 })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TemplateArtifactMapper : ResourceMapper<TemplateArtifact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.TemplateArtifact::class == javaResource::class

    override fun map(javaResource: Resource): TemplateArtifact = TemplateArtifact(
        javaResource as
            com.pulumi.azurenative.blueprint.TemplateArtifact,
    )
}

/**
 * @see [TemplateArtifact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateArtifact].
 */
public suspend fun templateArtifact(
    name: String,
    block: suspend TemplateArtifactResourceBuilder.() -> Unit,
): TemplateArtifact {
    val builder = TemplateArtifactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateArtifact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateArtifact(name: String): TemplateArtifact {
    val builder = TemplateArtifactResourceBuilder()
    builder.name(name)
    return builder.build()
}
