@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.AssignmentLockSettingsArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.enums.AssignmentLockMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *  /*
 * Defines how resources deployed by a blueprint assignment are locked.
 * @property excludedActions List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
 * @property excludedPrincipals List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
 * @property mode Lock mode.
 */
public data class AssignmentLockSettingsArgs(
    public val excludedActions: Output<List<String>>? = null,
    public val excludedPrincipals: Output<List<String>>? = null,
    public val mode: Output<Either<String, AssignmentLockMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.AssignmentLockSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.AssignmentLockSettingsArgs =
        com.pulumi.azurenative.blueprint.inputs.AssignmentLockSettingsArgs.builder()
            .excludedActions(excludedActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedPrincipals(excludedPrincipals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssignmentLockSettingsArgs].
 */
@PulumiTagMarker
public class AssignmentLockSettingsArgsBuilder internal constructor() {
    private var excludedActions: Output<List<String>>? = null

    private var excludedPrincipals: Output<List<String>>? = null

    private var mode: Output<Either<String, AssignmentLockMode>>? = null

    /**
     *  /*
     * @param value List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
     */
    @JvmName("xrpowwfoliyfqcih")
    public suspend fun excludedActions(`value`: Output<List<String>>) {
        this.excludedActions = value
    }

    @JvmName("rxtxjblccbctvcik")
    public suspend fun excludedActions(vararg values: Output<String>) {
        this.excludedActions = Output.all(values.asList())
    }

    /**
     *  /*
     * @param values List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
     */
    @JvmName("plmdlqvldidmiyrl")
    public suspend fun excludedActions(values: List<Output<String>>) {
        this.excludedActions = Output.all(values)
    }

    /**
     * @param value List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
     */
    @JvmName("bioposyaceiueidc")
    public suspend fun excludedPrincipals(`value`: Output<List<String>>) {
        this.excludedPrincipals = value
    }

    @JvmName("kilqwrdwkgkhciay")
    public suspend fun excludedPrincipals(vararg values: Output<String>) {
        this.excludedPrincipals = Output.all(values.asList())
    }

    /**
     * @param values List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
     */
    @JvmName("rmrbyrnlintvncvh")
    public suspend fun excludedPrincipals(values: List<Output<String>>) {
        this.excludedPrincipals = Output.all(values)
    }

    /**
     * @param value Lock mode.
     */
    @JvmName("bjjnkbnrhcbhklau")
    public suspend fun mode(`value`: Output<Either<String, AssignmentLockMode>>) {
        this.mode = value
    }

    /**
     *  /*
     * @param value List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
     */
    @JvmName("jvcdenvtxfeeqcae")
    public suspend fun excludedActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedActions = mapped
    }

    /**
     *  /*
     * @param values List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
     */
    @JvmName("cetqgqbjwuajcdxc")
    public suspend fun excludedActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedActions = mapped
    }

    /**
     * @param value List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
     */
    @JvmName("sswcleiprmcsvbvc")
    public suspend fun excludedPrincipals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedPrincipals = mapped
    }

    /**
     * @param values List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
     */
    @JvmName("qipxkvhbwhhfjbvw")
    public suspend fun excludedPrincipals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedPrincipals = mapped
    }

    /**
     * @param value Lock mode.
     */
    @JvmName("xycxactnaagyyepv")
    public suspend fun mode(`value`: Either<String, AssignmentLockMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Lock mode.
     */
    @JvmName("wxkvgcmlhvgycmvb")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssignmentLockMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Lock mode.
     */
    @JvmName("tautophxqgdlecjy")
    public fun mode(`value`: AssignmentLockMode) {
        val toBeMapped = Either.ofRight<String, AssignmentLockMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AssignmentLockSettingsArgs = AssignmentLockSettingsArgs(
        excludedActions = excludedActions,
        excludedPrincipals = excludedPrincipals,
        mode = mode,
    )
}
