@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.GetBlueprintPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blueprintName Name of the blueprint definition.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 */
public data class GetBlueprintPlainArgs(
    public val blueprintName: String,
    public val resourceScope: String,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.GetBlueprintPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.GetBlueprintPlainArgs =
        com.pulumi.azurenative.blueprint.inputs.GetBlueprintPlainArgs.builder()
            .blueprintName(blueprintName.let({ args0 -> args0 }))
            .resourceScope(resourceScope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlueprintPlainArgs].
 */
@PulumiTagMarker
public class GetBlueprintPlainArgsBuilder internal constructor() {
    private var blueprintName: String? = null

    private var resourceScope: String? = null

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("nslvfphirqsstesd")
    public suspend fun blueprintName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blueprintName = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("tbhcvauktylhboli")
    public suspend fun resourceScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceScope = mapped
    }

    internal fun build(): GetBlueprintPlainArgs = GetBlueprintPlainArgs(
        blueprintName = blueprintName ?: throw PulumiNullFieldException("blueprintName"),
        resourceScope = resourceScope ?: throw PulumiNullFieldException("resourceScope"),
    )
}
