@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.ResourceGroupValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an Azure resource group.
 * @property location Location of the resource group.
 * @property name Name of the resource group.
 */
public data class ResourceGroupValueArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.ResourceGroupValueArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.ResourceGroupValueArgs =
        com.pulumi.azurenative.blueprint.inputs.ResourceGroupValueArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceGroupValueArgs].
 */
@PulumiTagMarker
public class ResourceGroupValueArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Location of the resource group.
     */
    @JvmName("ewbbhcnmcwqieuxl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("ayjuffcpkulstpgq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Location of the resource group.
     */
    @JvmName("hqbgmfvhhmojjrjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("ousviishiptynmex")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ResourceGroupValueArgs = ResourceGroupValueArgs(
        location = location,
        name = name,
    )
}
