@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.SecretValueReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Reference to a Key Vault secret.
 * @property keyVault Specifies the reference to a given Azure Key Vault.
 * @property secretName Name of the secret.
 * @property secretVersion The version of the secret to use. If left blank, the latest version of the secret is used.
 */
public data class SecretValueReferenceArgs(
    public val keyVault: Output<KeyVaultReferenceArgs>,
    public val secretName: Output<String>,
    public val secretVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.SecretValueReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.SecretValueReferenceArgs =
        com.pulumi.azurenative.blueprint.inputs.SecretValueReferenceArgs.builder()
            .keyVault(keyVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName.applyValue({ args0 -> args0 }))
            .secretVersion(secretVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretValueReferenceArgs].
 */
@PulumiTagMarker
public class SecretValueReferenceArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultReferenceArgs>? = null

    private var secretName: Output<String>? = null

    private var secretVersion: Output<String>? = null

    /**
     * @param value Specifies the reference to a given Azure Key Vault.
     */
    @JvmName("qirupajrofftfbxe")
    public suspend fun keyVault(`value`: Output<KeyVaultReferenceArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Name of the secret.
     */
    @JvmName("bywgrwacknjkppds")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value The version of the secret to use. If left blank, the latest version of the secret is used.
     */
    @JvmName("wttkwecwuxcpfhen")
    public suspend fun secretVersion(`value`: Output<String>) {
        this.secretVersion = value
    }

    /**
     * @param value Specifies the reference to a given Azure Key Vault.
     */
    @JvmName("kphfebueoiwvyarg")
    public suspend fun keyVault(`value`: KeyVaultReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Specifies the reference to a given Azure Key Vault.
     */
    @JvmName("vgfttyavidvmciey")
    public suspend fun keyVault(argument: suspend KeyVaultReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Name of the secret.
     */
    @JvmName("tyxmbqtcgdaekmhl")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value The version of the secret to use. If left blank, the latest version of the secret is used.
     */
    @JvmName("hkyydvhpyeorvfyt")
    public suspend fun secretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    internal fun build(): SecretValueReferenceArgs = SecretValueReferenceArgs(
        keyVault = keyVault ?: throw PulumiNullFieldException("keyVault"),
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        secretVersion = secretVersion,
    )
}
