@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The status of a blueprint assignment. This field is readonly.
 * @property lastModified Last modified time of this blueprint definition.
 * @property managedResources List of resources that were created by the blueprint assignment.
 * @property timeCreated Creation time of this blueprint definition.
 */
public data class AssignmentStatusResponse(
    public val lastModified: String,
    public val managedResources: List<String>,
    public val timeCreated: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.AssignmentStatusResponse):
            AssignmentStatusResponse = AssignmentStatusResponse(
            lastModified = javaType.lastModified(),
            managedResources = javaType.managedResources().map({ args0 -> args0 }),
            timeCreated = javaType.timeCreated(),
        )
    }
}
