@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a published blueprint.
 * @property blueprintName Name of the published blueprint definition.
 * @property changeNotes Version-specific change notes.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property name Name of this resource.
 * @property parameters Parameters required by this blueprint definition.
 * @property resourceGroups Resource group placeholders defined by this blueprint definition.
 * @property status Status of the blueprint. This field is readonly.
 * @property targetScope The scope where this blueprint definition can be assigned.
 * @property type Type of this resource.
 */
public data class GetPublishedBlueprintResult(
    public val blueprintName: String? = null,
    public val changeNotes: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val parameters: Map<String, ParameterDefinitionResponse>? = null,
    public val resourceGroups: Map<String, ResourceGroupDefinitionResponse>? = null,
    public val status: BlueprintStatusResponse,
    public val targetScope: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetPublishedBlueprintResult):
            GetPublishedBlueprintResult = GetPublishedBlueprintResult(
            blueprintName = javaType.blueprintName().map({ args0 -> args0 }).orElse(null),
            changeNotes = javaType.changeNotes().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroups = javaType.resourceGroups().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse.Companion.toKotlin(args0)
            }),
            targetScope = javaType.targetScope().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
