@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represent a parameter with constrains and metadata.
 * @property allowedValues Array of allowed values for this parameter.
 * @property defaultValue Default Value for this parameter.
 * @property description Description of this parameter/resourceGroup.
 * @property displayName DisplayName of this parameter/resourceGroup.
 * @property strongType StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
 * @property type Allowed data types for Resource Manager template parameters.
 */
public data class ParameterDefinitionResponse(
    public val allowedValues: List<Any>? = null,
    public val defaultValue: Any? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val strongType: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.ParameterDefinitionResponse):
            ParameterDefinitionResponse = ParameterDefinitionResponse(
            allowedValues = javaType.allowedValues().map({ args0 -> args0 }),
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            strongType = javaType.strongType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
