@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to a Key Vault secret.
 * @property keyVault Specifies the reference to a given Azure Key Vault.
 * @property secretName Name of the secret.
 * @property secretVersion The version of the secret to use. If left blank, the latest version of the secret is used.
 */
public data class SecretValueReferenceResponse(
    public val keyVault: KeyVaultReferenceResponse,
    public val secretName: String,
    public val secretVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.SecretValueReferenceResponse):
            SecretValueReferenceResponse = SecretValueReferenceResponse(
            keyVault = javaType.keyVault().let({ args0 ->
                com.pulumi.azurenative.blueprint.kotlin.outputs.KeyVaultReferenceResponse.Companion.toKotlin(args0)
            }),
            secretName = javaType.secretName(),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
