@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.kotlin.outputs.BotPropertiesResponse
import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.botservice.kotlin.outputs.BotPropertiesResponse.Companion.toKotlin as botPropertiesResponseToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Bot].
 */
@PulumiTagMarker
public class BotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotArgs = BotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotArgsBuilder.() -> Unit) {
        val builder = BotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Bot {
        val builtJavaResource = com.pulumi.azurenative.botservice.Bot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bot(builtJavaResource)
    }
}

/**
 * Bot resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Bot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bot = new AzureNative.BotService.Bot("bot", new()
 *     {
 *         Kind = AzureNative.BotService.Kind.Sdk,
 *         Location = "West US",
 *         Properties = new AzureNative.BotService.Inputs.BotPropertiesArgs
 *         {
 *             CmekKeyVaultUrl = "https://myCmekKey",
 *             Description = "The description of the bot",
 *             DeveloperAppInsightKey = "appinsightskey",
 *             DeveloperAppInsightsApiKey = "appinsightsapikey",
 *             DeveloperAppInsightsApplicationId = "appinsightsappid",
 *             DisableLocalAuth = true,
 *             DisplayName = "The Name of the bot",
 *             Endpoint = "http://mybot.coffee",
 *             IconUrl = "http://myicon",
 *             IsCmekEnabled = true,
 *             LuisAppIds = new[]
 *             {
 *                 "luisappid1",
 *                 "luisappid2",
 *             },
 *             LuisKey = "luiskey",
 *             MsaAppId = "exampleappid",
 *             MsaAppMSIResourceId = "/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId",
 *             MsaAppTenantId = "exampleapptenantid",
 *             MsaAppType = AzureNative.BotService.MsaAppType.UserAssignedMSI,
 *             PublicNetworkAccess = AzureNative.BotService.PublicNetworkAccess.Enabled,
 *             SchemaTransformationVersion = "1.0",
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *         Sku = new AzureNative.BotService.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.BotService.SkuName.S1,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewBot(ctx, "bot", &botservice.BotArgs{
 * 			Kind:     pulumi.String(botservice.KindSdk),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &botservice.BotPropertiesArgs{
 * 				CmekKeyVaultUrl:                   pulumi.String("https://myCmekKey"),
 * 				Description:                       pulumi.String("The description of the bot"),
 * 				DeveloperAppInsightKey:            pulumi.String("appinsightskey"),
 * 				DeveloperAppInsightsApiKey:        pulumi.String("appinsightsapikey"),
 * 				DeveloperAppInsightsApplicationId: pulumi.String("appinsightsappid"),
 * 				DisableLocalAuth:                  pulumi.Bool(true),
 * 				DisplayName:                       pulumi.String("The Name of the bot"),
 * 				Endpoint:                          pulumi.String("http://mybot.coffee"),
 * 				IconUrl:                           pulumi.String("http://myicon"),
 * 				IsCmekEnabled:                     pulumi.Bool(true),
 * 				LuisAppIds: pulumi.StringArray{
 * 					pulumi.String("luisappid1"),
 * 					pulumi.String("luisappid2"),
 * 				},
 * 				LuisKey:                     pulumi.String("luiskey"),
 * 				MsaAppId:                    pulumi.String("exampleappid"),
 * 				MsaAppMSIResourceId:         pulumi.String("/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId"),
 * 				MsaAppTenantId:              pulumi.String("exampleapptenantid"),
 * 				MsaAppType:                  pulumi.String(botservice.MsaAppTypeUserAssignedMSI),
 * 				PublicNetworkAccess:         pulumi.String(botservice.PublicNetworkAccessEnabled),
 * 				SchemaTransformationVersion: pulumi.String("1.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 			Sku: &botservice.SkuArgs{
 * 				Name: pulumi.String(botservice.SkuNameS1),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Bot;
 * import com.pulumi.azurenative.botservice.BotArgs;
 * import com.pulumi.azurenative.botservice.inputs.BotPropertiesArgs;
 * import com.pulumi.azurenative.botservice.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bot = new Bot("bot", BotArgs.builder()
 *             .kind("sdk")
 *             .location("West US")
 *             .properties(BotPropertiesArgs.builder()
 *                 .cmekKeyVaultUrl("https://myCmekKey")
 *                 .description("The description of the bot")
 *                 .developerAppInsightKey("appinsightskey")
 *                 .developerAppInsightsApiKey("appinsightsapikey")
 *                 .developerAppInsightsApplicationId("appinsightsappid")
 *                 .disableLocalAuth(true)
 *                 .displayName("The Name of the bot")
 *                 .endpoint("http://mybot.coffee")
 *                 .iconUrl("http://myicon")
 *                 .isCmekEnabled(true)
 *                 .luisAppIds(
 *                     "luisappid1",
 *                     "luisappid2")
 *                 .luisKey("luiskey")
 *                 .msaAppId("exampleappid")
 *                 .msaAppMSIResourceId("/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId")
 *                 .msaAppTenantId("exampleapptenantid")
 *                 .msaAppType("UserAssignedMSI")
 *                 .publicNetworkAccess("Enabled")
 *                 .schemaTransformationVersion("1.0")
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .sku(SkuArgs.builder()
 *                 .name("S1")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:Bot samplebotname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}
 * ```
 */
public class Bot internal constructor(
    override val javaResource: com.pulumi.azurenative.botservice.Bot,
) : KotlinCustomResource(javaResource, BotMapper) {
    /**
     * Entity Tag.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Required. Gets or sets the Kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of properties specific to bot resource
     */
    public val properties: Output<BotPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                botPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Entity zones
     */
    public val zones: Output<List<String>>
        get() = javaResource.zones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object BotMapper : ResourceMapper<Bot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.botservice.Bot::class == javaResource::class

    override fun map(javaResource: Resource): Bot = Bot(
        javaResource as
            com.pulumi.azurenative.botservice.Bot,
    )
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bot].
 */
public suspend fun bot(name: String, block: suspend BotResourceBuilder.() -> Unit): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bot(name: String): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    return builder.build()
}
