@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.azurenative.botservice.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * Bot channel resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Alexa Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "AlexaChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.AlexaChannelArgs
 *         {
 *             ChannelName = "AlexaChannel",
 *             Properties = new AzureNative.BotService.Inputs.AlexaChannelPropertiesArgs
 *             {
 *                 AlexaSkillId = "XAlexaSkillIdX",
 *                 IsEnabled = true,
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("AlexaChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.AlexaChannel{
 * 				ChannelName: "AlexaChannel",
 * 				Properties: botservice.AlexaChannelProperties{
 * 					AlexaSkillId: "XAlexaSkillIdX",
 * 					IsEnabled:    true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("AlexaChannel")
 *             .location("global")
 *             .properties(AlexaChannelArgs.builder()
 *                 .channelName("AlexaChannel")
 *                 .properties(AlexaChannelPropertiesArgs.builder()
 *                     .alexaSkillId("XAlexaSkillIdX")
 *                     .isEnabled(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "EmailChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.EmailChannelArgs
 *         {
 *             ChannelName = "EmailChannel",
 *             Properties = new AzureNative.BotService.Inputs.EmailChannelPropertiesArgs
 *             {
 *                 EmailAddress = "a@b.com",
 *                 IsEnabled = true,
 *                 Password = "pwd",
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("EmailChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.EmailChannel{
 * 				ChannelName: "EmailChannel",
 * 				Properties: botservice.EmailChannelProperties{
 * 					EmailAddress: "a@b.com",
 * 					IsEnabled:    true,
 * 					Password:     "pwd",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("EmailChannel")
 *             .location("global")
 *             .properties(EmailChannelArgs.builder()
 *                 .channelName("EmailChannel")
 *                 .properties(EmailChannelPropertiesArgs.builder()
 *                     .emailAddress("a@b.com")
 *                     .isEnabled(true)
 *                     .password("pwd")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create DirectLine Speech Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "DirectLineSpeechChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.DirectLineSpeechChannelArgs
 *         {
 *             ChannelName = "DirectLineSpeechChannel",
 *             Properties = new AzureNative.BotService.Inputs.DirectLineSpeechChannelPropertiesArgs
 *             {
 *                 CognitiveServiceRegion = "XcognitiveServiceRegionX",
 *                 CognitiveServiceSubscriptionKey = "XcognitiveServiceSubscriptionKeyX",
 *                 IsEnabled = true,
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("DirectLineSpeechChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.DirectLineSpeechChannel{
 * 				ChannelName: "DirectLineSpeechChannel",
 * 				Properties: botservice.DirectLineSpeechChannelProperties{
 * 					CognitiveServiceRegion:          "XcognitiveServiceRegionX",
 * 					CognitiveServiceSubscriptionKey: "XcognitiveServiceSubscriptionKeyX",
 * 					IsEnabled:                       true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("DirectLineSpeechChannel")
 *             .location("global")
 *             .properties(DirectLineSpeechChannelArgs.builder()
 *                 .channelName("DirectLineSpeechChannel")
 *                 .properties(DirectLineSpeechChannelPropertiesArgs.builder()
 *                     .cognitiveServiceRegion("XcognitiveServiceRegionX")
 *                     .cognitiveServiceSubscriptionKey("XcognitiveServiceSubscriptionKeyX")
 *                     .isEnabled(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Email Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "EmailChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.EmailChannelArgs
 *         {
 *             ChannelName = "EmailChannel",
 *             Properties = new AzureNative.BotService.Inputs.EmailChannelPropertiesArgs
 *             {
 *                 AuthMethod = 1,
 *                 EmailAddress = "a@b.com",
 *                 IsEnabled = true,
 *                 MagicCode = "000000",
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("EmailChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.EmailChannel{
 * 				ChannelName: "EmailChannel",
 * 				Properties: botservice.EmailChannelProperties{
 * 					AuthMethod:   1,
 * 					EmailAddress: "a@b.com",
 * 					IsEnabled:    true,
 * 					MagicCode:    "000000",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("EmailChannel")
 *             .location("global")
 *             .properties(EmailChannelArgs.builder()
 *                 .channelName("EmailChannel")
 *                 .properties(EmailChannelPropertiesArgs.builder()
 *                     .authMethod(1)
 *                     .emailAddress("a@b.com")
 *                     .isEnabled(true)
 *                     .magicCode("000000")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Line Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "LineChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.LineChannelArgs
 *         {
 *             ChannelName = "LineChannel",
 *             Properties = new AzureNative.BotService.Inputs.LineChannelPropertiesArgs
 *             {
 *                 LineRegistrations = new[]
 *                 {
 *                     new AzureNative.BotService.Inputs.LineRegistrationArgs
 *                     {
 *                         ChannelAccessToken = "channelAccessToken",
 *                         ChannelSecret = "channelSecret",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("LineChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.LineChannel{
 * 				ChannelName: "LineChannel",
 * 				Properties: botservice.LineChannelProperties{
 * 					LineRegistrations: []botservice.LineRegistration{
 * 						{
 * 							ChannelAccessToken: "channelAccessToken",
 * 							ChannelSecret:      "channelSecret",
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("LineChannel")
 *             .location("global")
 *             .properties(DirectLineChannelArgs.builder()
 *                 .channelName("LineChannel")
 *                 .properties(DirectLineChannelPropertiesArgs.builder()
 *                     .lineRegistrations(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:Channel myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}
 * ```
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.azurenative.botservice.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * Entity Tag.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Required. Gets or sets the Kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of properties specific to bot channel resource
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Entity zones
     */
    public val zones: Output<List<String>>
        get() = javaResource.zones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.botservice.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.azurenative.botservice.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit):
    Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
