@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.BotPropertiesArgs.builder
import com.pulumi.azurenative.botservice.kotlin.enums.MsaAppType
import com.pulumi.azurenative.botservice.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Bot.
 * @property allSettings Contains resource all settings defined as key/value pairs.
 * @property appPasswordHint The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
 * @property cmekKeyVaultUrl The CMK Url
 * @property description The description of the bot
 * @property developerAppInsightKey The Application Insights key
 * @property developerAppInsightsApiKey The Application Insights Api Key
 * @property developerAppInsightsApplicationId The Application Insights App Id
 * @property disableLocalAuth Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
 * @property displayName The Name of the bot
 * @property endpoint The bot's endpoint
 * @property iconUrl The Icon Url of the bot
 * @property isCmekEnabled Whether Cmek is enabled
 * @property isStreamingSupported Whether the bot is streaming supported
 * @property luisAppIds Collection of LUIS App Ids
 * @property luisKey The LUIS Key
 * @property manifestUrl The bot's manifest url
 * @property msaAppId Microsoft App Id for the bot
 * @property msaAppMSIResourceId Microsoft App Managed Identity Resource Id for the bot
 * @property msaAppTenantId Microsoft App Tenant Id for the bot
 * @property msaAppType Microsoft App Type for the bot
 * @property openWithHint The hint to browser (e.g. protocol handler) on how to open the bot for authoring
 * @property parameters Contains resource parameters defined as key/value pairs.
 * @property publicNetworkAccess Whether the bot is in an isolated network
 * @property publishingCredentials Publishing credentials of the resource
 * @property schemaTransformationVersion The channel schema transformation version for the bot
 * @property storageResourceId The storage resourceId for the bot
 * @property tenantId The Tenant Id for the bot
 */
public data class BotPropertiesArgs(
    public val allSettings: Output<Map<String, String>>? = null,
    public val appPasswordHint: Output<String>? = null,
    public val cmekKeyVaultUrl: Output<String>? = null,
    public val description: Output<String>? = null,
    public val developerAppInsightKey: Output<String>? = null,
    public val developerAppInsightsApiKey: Output<String>? = null,
    public val developerAppInsightsApplicationId: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val displayName: Output<String>,
    public val endpoint: Output<String>,
    public val iconUrl: Output<String>? = null,
    public val isCmekEnabled: Output<Boolean>? = null,
    public val isStreamingSupported: Output<Boolean>? = null,
    public val luisAppIds: Output<List<String>>? = null,
    public val luisKey: Output<String>? = null,
    public val manifestUrl: Output<String>? = null,
    public val msaAppId: Output<String>,
    public val msaAppMSIResourceId: Output<String>? = null,
    public val msaAppTenantId: Output<String>? = null,
    public val msaAppType: Output<Either<String, MsaAppType>>? = null,
    public val openWithHint: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val publishingCredentials: Output<String>? = null,
    public val schemaTransformationVersion: Output<String>? = null,
    public val storageResourceId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.BotPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.BotPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.BotPropertiesArgs.builder()
            .allSettings(
                allSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .appPasswordHint(appPasswordHint?.applyValue({ args0 -> args0 }))
            .cmekKeyVaultUrl(cmekKeyVaultUrl?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .developerAppInsightKey(developerAppInsightKey?.applyValue({ args0 -> args0 }))
            .developerAppInsightsApiKey(developerAppInsightsApiKey?.applyValue({ args0 -> args0 }))
            .developerAppInsightsApplicationId(
                developerAppInsightsApplicationId?.applyValue({ args0 ->
                    args0
                }),
            )
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .displayName(displayName.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .iconUrl(iconUrl?.applyValue({ args0 -> args0 }))
            .isCmekEnabled(isCmekEnabled?.applyValue({ args0 -> args0 }))
            .isStreamingSupported(isStreamingSupported?.applyValue({ args0 -> args0 }))
            .luisAppIds(luisAppIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .luisKey(luisKey?.applyValue({ args0 -> args0 }))
            .manifestUrl(manifestUrl?.applyValue({ args0 -> args0 }))
            .msaAppId(msaAppId.applyValue({ args0 -> args0 }))
            .msaAppMSIResourceId(msaAppMSIResourceId?.applyValue({ args0 -> args0 }))
            .msaAppTenantId(msaAppTenantId?.applyValue({ args0 -> args0 }))
            .msaAppType(
                msaAppType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .openWithHint(openWithHint?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publishingCredentials(publishingCredentials?.applyValue({ args0 -> args0 }))
            .schemaTransformationVersion(schemaTransformationVersion?.applyValue({ args0 -> args0 }))
            .storageResourceId(storageResourceId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotPropertiesArgs].
 */
@PulumiTagMarker
public class BotPropertiesArgsBuilder internal constructor() {
    private var allSettings: Output<Map<String, String>>? = null

    private var appPasswordHint: Output<String>? = null

    private var cmekKeyVaultUrl: Output<String>? = null

    private var description: Output<String>? = null

    private var developerAppInsightKey: Output<String>? = null

    private var developerAppInsightsApiKey: Output<String>? = null

    private var developerAppInsightsApplicationId: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var displayName: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var iconUrl: Output<String>? = null

    private var isCmekEnabled: Output<Boolean>? = null

    private var isStreamingSupported: Output<Boolean>? = null

    private var luisAppIds: Output<List<String>>? = null

    private var luisKey: Output<String>? = null

    private var manifestUrl: Output<String>? = null

    private var msaAppId: Output<String>? = null

    private var msaAppMSIResourceId: Output<String>? = null

    private var msaAppTenantId: Output<String>? = null

    private var msaAppType: Output<Either<String, MsaAppType>>? = null

    private var openWithHint: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var publishingCredentials: Output<String>? = null

    private var schemaTransformationVersion: Output<String>? = null

    private var storageResourceId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Contains resource all settings defined as key/value pairs.
     */
    @JvmName("csafxuknvmmjnkct")
    public suspend fun allSettings(`value`: Output<Map<String, String>>) {
        this.allSettings = value
    }

    /**
     * @param value The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
     */
    @JvmName("rgnlxtwjuwermywo")
    public suspend fun appPasswordHint(`value`: Output<String>) {
        this.appPasswordHint = value
    }

    /**
     * @param value The CMK Url
     */
    @JvmName("yiiwguqdnoubbdwh")
    public suspend fun cmekKeyVaultUrl(`value`: Output<String>) {
        this.cmekKeyVaultUrl = value
    }

    /**
     * @param value The description of the bot
     */
    @JvmName("wjrohegldlownibc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Application Insights key
     */
    @JvmName("yopcprtwcexngxaj")
    public suspend fun developerAppInsightKey(`value`: Output<String>) {
        this.developerAppInsightKey = value
    }

    /**
     * @param value The Application Insights Api Key
     */
    @JvmName("ykofeaeybyauqjvh")
    public suspend fun developerAppInsightsApiKey(`value`: Output<String>) {
        this.developerAppInsightsApiKey = value
    }

    /**
     * @param value The Application Insights App Id
     */
    @JvmName("tucuoocxhbqivrwc")
    public suspend fun developerAppInsightsApplicationId(`value`: Output<String>) {
        this.developerAppInsightsApplicationId = value
    }

    /**
     * @param value Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    @JvmName("hdqtgehlwhpwytoh")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value The Name of the bot
     */
    @JvmName("emjnuaalbnnchgyr")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The bot's endpoint
     */
    @JvmName("xakqhmruiqqsnmsx")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The Icon Url of the bot
     */
    @JvmName("xivliduolkfkpxvi")
    public suspend fun iconUrl(`value`: Output<String>) {
        this.iconUrl = value
    }

    /**
     * @param value Whether Cmek is enabled
     */
    @JvmName("onggjotnwepopofx")
    public suspend fun isCmekEnabled(`value`: Output<Boolean>) {
        this.isCmekEnabled = value
    }

    /**
     * @param value Whether the bot is streaming supported
     */
    @JvmName("ehldhpvupuytmdtk")
    public suspend fun isStreamingSupported(`value`: Output<Boolean>) {
        this.isStreamingSupported = value
    }

    /**
     * @param value Collection of LUIS App Ids
     */
    @JvmName("ytjiwbmmvrkxxggs")
    public suspend fun luisAppIds(`value`: Output<List<String>>) {
        this.luisAppIds = value
    }

    @JvmName("jdmvmvcluoeybqxi")
    public suspend fun luisAppIds(vararg values: Output<String>) {
        this.luisAppIds = Output.all(values.asList())
    }

    /**
     * @param values Collection of LUIS App Ids
     */
    @JvmName("usjmmeqdjlehbpqe")
    public suspend fun luisAppIds(values: List<Output<String>>) {
        this.luisAppIds = Output.all(values)
    }

    /**
     * @param value The LUIS Key
     */
    @JvmName("fxsxbmwpkttrtjcq")
    public suspend fun luisKey(`value`: Output<String>) {
        this.luisKey = value
    }

    /**
     * @param value The bot's manifest url
     */
    @JvmName("ieruycwsidhnydee")
    public suspend fun manifestUrl(`value`: Output<String>) {
        this.manifestUrl = value
    }

    /**
     * @param value Microsoft App Id for the bot
     */
    @JvmName("xcaqeeggrijtvbju")
    public suspend fun msaAppId(`value`: Output<String>) {
        this.msaAppId = value
    }

    /**
     * @param value Microsoft App Managed Identity Resource Id for the bot
     */
    @JvmName("lcmauwdsoeswqqhf")
    public suspend fun msaAppMSIResourceId(`value`: Output<String>) {
        this.msaAppMSIResourceId = value
    }

    /**
     * @param value Microsoft App Tenant Id for the bot
     */
    @JvmName("cgvnqpcgsysnnyft")
    public suspend fun msaAppTenantId(`value`: Output<String>) {
        this.msaAppTenantId = value
    }

    /**
     * @param value Microsoft App Type for the bot
     */
    @JvmName("ioykogmmpbdesjsw")
    public suspend fun msaAppType(`value`: Output<Either<String, MsaAppType>>) {
        this.msaAppType = value
    }

    /**
     * @param value The hint to browser (e.g. protocol handler) on how to open the bot for authoring
     */
    @JvmName("emmeraibjggiwavj")
    public suspend fun openWithHint(`value`: Output<String>) {
        this.openWithHint = value
    }

    /**
     * @param value Contains resource parameters defined as key/value pairs.
     */
    @JvmName("nadlophysmbykejp")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Whether the bot is in an isolated network
     */
    @JvmName("xmbwdnqctqqoohqq")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Publishing credentials of the resource
     */
    @JvmName("yjwbqahpfflcuatb")
    public suspend fun publishingCredentials(`value`: Output<String>) {
        this.publishingCredentials = value
    }

    /**
     * @param value The channel schema transformation version for the bot
     */
    @JvmName("vcrxdhxtyxlwauev")
    public suspend fun schemaTransformationVersion(`value`: Output<String>) {
        this.schemaTransformationVersion = value
    }

    /**
     * @param value The storage resourceId for the bot
     */
    @JvmName("irjldsnecjiuuree")
    public suspend fun storageResourceId(`value`: Output<String>) {
        this.storageResourceId = value
    }

    /**
     * @param value The Tenant Id for the bot
     */
    @JvmName("dcrfbfoiiylgdykl")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Contains resource all settings defined as key/value pairs.
     */
    @JvmName("sgqcbegquberkuqw")
    public suspend fun allSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allSettings = mapped
    }

    /**
     * @param values Contains resource all settings defined as key/value pairs.
     */
    @JvmName("wllquexxhpnhxqgd")
    public fun allSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allSettings = mapped
    }

    /**
     * @param value The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
     */
    @JvmName("athoeaslkvxxpvhh")
    public suspend fun appPasswordHint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appPasswordHint = mapped
    }

    /**
     * @param value The CMK Url
     */
    @JvmName("gcqlycbcbxiukuox")
    public suspend fun cmekKeyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmekKeyVaultUrl = mapped
    }

    /**
     * @param value The description of the bot
     */
    @JvmName("qfhymaivcdvnkysv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Application Insights key
     */
    @JvmName("jcvlgfxrfipyjwbd")
    public suspend fun developerAppInsightKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerAppInsightKey = mapped
    }

    /**
     * @param value The Application Insights Api Key
     */
    @JvmName("dsxkujchlbmaaljv")
    public suspend fun developerAppInsightsApiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerAppInsightsApiKey = mapped
    }

    /**
     * @param value The Application Insights App Id
     */
    @JvmName("fwarcwclgwfpioeq")
    public suspend fun developerAppInsightsApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerAppInsightsApplicationId = mapped
    }

    /**
     * @param value Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    @JvmName("bnkqcguaytiikyoo")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value The Name of the bot
     */
    @JvmName("jxuonhaxnwjmhhkg")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The bot's endpoint
     */
    @JvmName("prrqhtoltbbuwukm")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The Icon Url of the bot
     */
    @JvmName("rcrxhjjyxbcqtxvv")
    public suspend fun iconUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconUrl = mapped
    }

    /**
     * @param value Whether Cmek is enabled
     */
    @JvmName("dkxslqkeodqjkedt")
    public suspend fun isCmekEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCmekEnabled = mapped
    }

    /**
     * @param value Whether the bot is streaming supported
     */
    @JvmName("mjnqkheexdmyxurn")
    public suspend fun isStreamingSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isStreamingSupported = mapped
    }

    /**
     * @param value Collection of LUIS App Ids
     */
    @JvmName("ugmynkntjgqxivcj")
    public suspend fun luisAppIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.luisAppIds = mapped
    }

    /**
     * @param values Collection of LUIS App Ids
     */
    @JvmName("ubrokqljcncgvmca")
    public suspend fun luisAppIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.luisAppIds = mapped
    }

    /**
     * @param value The LUIS Key
     */
    @JvmName("heisxlymeweygips")
    public suspend fun luisKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.luisKey = mapped
    }

    /**
     * @param value The bot's manifest url
     */
    @JvmName("ncumedasmghpxgko")
    public suspend fun manifestUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestUrl = mapped
    }

    /**
     * @param value Microsoft App Id for the bot
     */
    @JvmName("ylxshuteqtkcehqc")
    public suspend fun msaAppId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.msaAppId = mapped
    }

    /**
     * @param value Microsoft App Managed Identity Resource Id for the bot
     */
    @JvmName("mrqxtoxvwbweoiro")
    public suspend fun msaAppMSIResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msaAppMSIResourceId = mapped
    }

    /**
     * @param value Microsoft App Tenant Id for the bot
     */
    @JvmName("nplrvgtvwmubrtxp")
    public suspend fun msaAppTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msaAppTenantId = mapped
    }

    /**
     * @param value Microsoft App Type for the bot
     */
    @JvmName("gtfquviicavltile")
    public suspend fun msaAppType(`value`: Either<String, MsaAppType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msaAppType = mapped
    }

    /**
     * @param value Microsoft App Type for the bot
     */
    @JvmName("ymcoqssjolilvbnu")
    public fun msaAppType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MsaAppType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.msaAppType = mapped
    }

    /**
     * @param value Microsoft App Type for the bot
     */
    @JvmName("ufllarpvbiibxoko")
    public fun msaAppType(`value`: MsaAppType) {
        val toBeMapped = Either.ofRight<String, MsaAppType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.msaAppType = mapped
    }

    /**
     * @param value The hint to browser (e.g. protocol handler) on how to open the bot for authoring
     */
    @JvmName("rrauqajleayvpjxv")
    public suspend fun openWithHint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openWithHint = mapped
    }

    /**
     * @param value Contains resource parameters defined as key/value pairs.
     */
    @JvmName("qdvjicgqgxagqqvy")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Contains resource parameters defined as key/value pairs.
     */
    @JvmName("jopxpeytmennnpik")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Whether the bot is in an isolated network
     */
    @JvmName("ejwnehfxfrtatmjm")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether the bot is in an isolated network
     */
    @JvmName("itsxywrpkbtbpjps")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether the bot is in an isolated network
     */
    @JvmName("qsxapjxoqdivfnyb")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Publishing credentials of the resource
     */
    @JvmName("qnlirknbsqwvsaoy")
    public suspend fun publishingCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishingCredentials = mapped
    }

    /**
     * @param value The channel schema transformation version for the bot
     */
    @JvmName("kxtyemfuckjxemyj")
    public suspend fun schemaTransformationVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaTransformationVersion = mapped
    }

    /**
     * @param value The storage resourceId for the bot
     */
    @JvmName("bsawmtmevxpudlnv")
    public suspend fun storageResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageResourceId = mapped
    }

    /**
     * @param value The Tenant Id for the bot
     */
    @JvmName("knqbguvxknbdwrph")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): BotPropertiesArgs = BotPropertiesArgs(
        allSettings = allSettings,
        appPasswordHint = appPasswordHint,
        cmekKeyVaultUrl = cmekKeyVaultUrl,
        description = description,
        developerAppInsightKey = developerAppInsightKey,
        developerAppInsightsApiKey = developerAppInsightsApiKey,
        developerAppInsightsApplicationId = developerAppInsightsApplicationId,
        disableLocalAuth = disableLocalAuth,
        displayName = displayName ?: throw PulumiNullFieldException("displayName"),
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        iconUrl = iconUrl,
        isCmekEnabled = isCmekEnabled,
        isStreamingSupported = isStreamingSupported,
        luisAppIds = luisAppIds,
        luisKey = luisKey,
        manifestUrl = manifestUrl,
        msaAppId = msaAppId ?: throw PulumiNullFieldException("msaAppId"),
        msaAppMSIResourceId = msaAppMSIResourceId,
        msaAppTenantId = msaAppTenantId,
        msaAppType = msaAppType,
        openWithHint = openWithHint,
        parameters = parameters,
        publicNetworkAccess = publicNetworkAccess,
        publishingCredentials = publishingCredentials,
        schemaTransformationVersion = schemaTransformationVersion,
        storageResourceId = storageResourceId,
        tenantId = tenantId,
    )
}
