@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.FacebookChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Facebook channel.
 * @property appId Facebook application id
 * @property appSecret Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property pages The list of Facebook pages
 */
public data class FacebookChannelPropertiesArgs(
    public val appId: Output<String>,
    public val appSecret: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val pages: Output<List<FacebookPageArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.FacebookChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.FacebookChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.FacebookChannelPropertiesArgs.builder()
            .appId(appId.applyValue({ args0 -> args0 }))
            .appSecret(appSecret?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .pages(
                pages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FacebookChannelPropertiesArgs].
 */
@PulumiTagMarker
public class FacebookChannelPropertiesArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appSecret: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var pages: Output<List<FacebookPageArgs>>? = null

    /**
     * @param value Facebook application id
     */
    @JvmName("buclaibjxlhmcsav")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("peaxgnsbieodbknw")
    public suspend fun appSecret(`value`: Output<String>) {
        this.appSecret = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("tvjgqwelscoswkrc")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The list of Facebook pages
     */
    @JvmName("pfdodddwbepmdmww")
    public suspend fun pages(`value`: Output<List<FacebookPageArgs>>) {
        this.pages = value
    }

    @JvmName("brubotwryekfnwdf")
    public suspend fun pages(vararg values: Output<FacebookPageArgs>) {
        this.pages = Output.all(values.asList())
    }

    /**
     * @param values The list of Facebook pages
     */
    @JvmName("qosxdsaygumgsqyb")
    public suspend fun pages(values: List<Output<FacebookPageArgs>>) {
        this.pages = Output.all(values)
    }

    /**
     * @param value Facebook application id
     */
    @JvmName("huvjwtuginhohjoe")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("fwgegfmtsmsvjymn")
    public suspend fun appSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSecret = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("wrbihvujeqofqonf")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The list of Facebook pages
     */
    @JvmName("wduwhetonvjqihcl")
    public suspend fun pages(`value`: List<FacebookPageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pages = mapped
    }

    /**
     * @param argument The list of Facebook pages
     */
    @JvmName("qvuytnidemfpngxu")
    public suspend fun pages(argument: List<suspend FacebookPageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FacebookPageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pages = mapped
    }

    /**
     * @param argument The list of Facebook pages
     */
    @JvmName("dseqauaqwpqlcgmr")
    public suspend fun pages(vararg argument: suspend FacebookPageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FacebookPageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pages = mapped
    }

    /**
     * @param argument The list of Facebook pages
     */
    @JvmName("xppfhcmqiipqnkpe")
    public suspend fun pages(argument: suspend FacebookPageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FacebookPageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pages = mapped
    }

    /**
     * @param values The list of Facebook pages
     */
    @JvmName("lfasjeprgvexogiq")
    public suspend fun pages(vararg values: FacebookPageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pages = mapped
    }

    internal fun build(): FacebookChannelPropertiesArgs = FacebookChannelPropertiesArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        appSecret = appSecret,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        pages = pages,
    )
}
