@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.LineChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Line channel.
 * @property lineRegistrations The list of line channel registrations
 */
public data class LineChannelPropertiesArgs(
    public val lineRegistrations: Output<List<LineRegistrationArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.LineChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.LineChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.LineChannelPropertiesArgs.builder()
            .lineRegistrations(
                lineRegistrations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LineChannelPropertiesArgs].
 */
@PulumiTagMarker
public class LineChannelPropertiesArgsBuilder internal constructor() {
    private var lineRegistrations: Output<List<LineRegistrationArgs>>? = null

    /**
     * @param value The list of line channel registrations
     */
    @JvmName("vpfphgebxxcselyi")
    public suspend fun lineRegistrations(`value`: Output<List<LineRegistrationArgs>>) {
        this.lineRegistrations = value
    }

    @JvmName("wybbbnbprbqwvkad")
    public suspend fun lineRegistrations(vararg values: Output<LineRegistrationArgs>) {
        this.lineRegistrations = Output.all(values.asList())
    }

    /**
     * @param values The list of line channel registrations
     */
    @JvmName("qwgtbjtmwqedvbwr")
    public suspend fun lineRegistrations(values: List<Output<LineRegistrationArgs>>) {
        this.lineRegistrations = Output.all(values)
    }

    /**
     * @param value The list of line channel registrations
     */
    @JvmName("tuwbakjqwoinmash")
    public suspend fun lineRegistrations(`value`: List<LineRegistrationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lineRegistrations = mapped
    }

    /**
     * @param argument The list of line channel registrations
     */
    @JvmName("wnauelflnkgdfxuj")
    public suspend
    fun lineRegistrations(argument: List<suspend LineRegistrationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LineRegistrationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lineRegistrations = mapped
    }

    /**
     * @param argument The list of line channel registrations
     */
    @JvmName("cowevtqbecxywqcm")
    public suspend fun lineRegistrations(
        vararg
        argument: suspend LineRegistrationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LineRegistrationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lineRegistrations = mapped
    }

    /**
     * @param argument The list of line channel registrations
     */
    @JvmName("avcpgckubkdocqgp")
    public suspend fun lineRegistrations(argument: suspend LineRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LineRegistrationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lineRegistrations = mapped
    }

    /**
     * @param values The list of line channel registrations
     */
    @JvmName("enmoclcnbqgfeocr")
    public suspend fun lineRegistrations(vararg values: LineRegistrationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lineRegistrations = mapped
    }

    internal fun build(): LineChannelPropertiesArgs = LineChannelPropertiesArgs(
        lineRegistrations = lineRegistrations ?: throw PulumiNullFieldException("lineRegistrations"),
    )
}
