@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.LineRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties corresponding to a line channel registration
 * @property channelAccessToken Access token for the line channel registration
 * @property channelSecret Secret for the line channel registration
 */
public data class LineRegistrationArgs(
    public val channelAccessToken: Output<String>? = null,
    public val channelSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.LineRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.LineRegistrationArgs =
        com.pulumi.azurenative.botservice.inputs.LineRegistrationArgs.builder()
            .channelAccessToken(channelAccessToken?.applyValue({ args0 -> args0 }))
            .channelSecret(channelSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LineRegistrationArgs].
 */
@PulumiTagMarker
public class LineRegistrationArgsBuilder internal constructor() {
    private var channelAccessToken: Output<String>? = null

    private var channelSecret: Output<String>? = null

    /**
     * @param value Access token for the line channel registration
     */
    @JvmName("blghihtdqcyqefhr")
    public suspend fun channelAccessToken(`value`: Output<String>) {
        this.channelAccessToken = value
    }

    /**
     * @param value Secret for the line channel registration
     */
    @JvmName("gqhcnpdfgrhxjlwa")
    public suspend fun channelSecret(`value`: Output<String>) {
        this.channelSecret = value
    }

    /**
     * @param value Access token for the line channel registration
     */
    @JvmName("nnrsdlffpjkapoec")
    public suspend fun channelAccessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelAccessToken = mapped
    }

    /**
     * @param value Secret for the line channel registration
     */
    @JvmName("eyduuqmvescdejat")
    public suspend fun channelSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelSecret = mapped
    }

    internal fun build(): LineRegistrationArgs = LineRegistrationArgs(
        channelAccessToken = channelAccessToken,
        channelSecret = channelSecret,
    )
}
