@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.TelegramChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Telegram channel.
 * @property accessToken The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 */
public data class TelegramChannelPropertiesArgs(
    public val accessToken: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val isValidated: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.TelegramChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.TelegramChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.TelegramChannelPropertiesArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .isValidated(isValidated?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TelegramChannelPropertiesArgs].
 */
@PulumiTagMarker
public class TelegramChannelPropertiesArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var isValidated: Output<Boolean>? = null

    /**
     * @param value The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("svfudukvlvgqiqft")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("xxkqifwpiwrxebmp")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("hdgpgaxqfrxdnvyo")
    public suspend fun isValidated(`value`: Output<Boolean>) {
        this.isValidated = value
    }

    /**
     * @param value The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("kcymxwotyrvgkvtk")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("mednbnfgowowduih")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("qbhpoadnjmaqkvka")
    public suspend fun isValidated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValidated = mapped
    }

    internal fun build(): TelegramChannelPropertiesArgs = TelegramChannelPropertiesArgs(
        accessToken = accessToken,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        isValidated = isValidated,
    )
}
