@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU of the cognitive services account.
 * @property name The sku name
 * @property tier Gets the sku tier. This is based on the SKU name.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
