@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters to provide for the Direct Line channel.
 * @property apiConfigurations The list of Telephony api configuration
 * @property cognitiveServiceRegion The extensionKey2
 * @property cognitiveServiceSubscriptionKey The extensionKey1
 * @property defaultLocale The default locale of the channel
 * @property isEnabled Whether the channel is enabled
 * @property phoneNumbers The list of Telephony phone numbers
 * @property premiumSKU The premium SKU applied to the channel
 */
public data class TelephonyChannelPropertiesResponse(
    public val apiConfigurations: List<TelephonyChannelResourceApiConfigurationResponse>? = null,
    public val cognitiveServiceRegion: String? = null,
    public val cognitiveServiceSubscriptionKey: String? = null,
    public val defaultLocale: String? = null,
    public val isEnabled: Boolean? = null,
    public val phoneNumbers: List<TelephonyPhoneNumbersResponse>? = null,
    public val premiumSKU: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.TelephonyChannelPropertiesResponse):
            TelephonyChannelPropertiesResponse = TelephonyChannelPropertiesResponse(
            apiConfigurations = javaType.apiConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.TelephonyChannelResourceApiConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            cognitiveServiceRegion = javaType.cognitiveServiceRegion().map({ args0 -> args0 }).orElse(null),
            cognitiveServiceSubscriptionKey = javaType.cognitiveServiceSubscriptionKey().map({ args0 ->
                args0
            }).orElse(null),
            defaultLocale = javaType.defaultLocale().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            phoneNumbers = javaType.phoneNumbers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.TelephonyPhoneNumbersResponse.Companion.toKotlin(args0)
                })
            }),
            premiumSKU = javaType.premiumSKU().map({ args0 -> args0 }).orElse(null),
        )
    }
}
