@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.AccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Response to get/put access policy.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### RedisCacheAccessPolicyCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicy = new AzureNative.Cache.AccessPolicy("accessPolicy", new()
 *     {
 *         AccessPolicyName = "accessPolicy1",
 *         CacheName = "cache1",
 *         Permissions = "+get +hget",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewAccessPolicy(ctx, "accessPolicy", &cache.AccessPolicyArgs{
 * 			AccessPolicyName:  pulumi.String("accessPolicy1"),
 * 			CacheName:         pulumi.String("cache1"),
 * 			Permissions:       pulumi.String("+get +hget"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.AccessPolicy;
 * import com.pulumi.azurenative.cache.AccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicy = new AccessPolicy("accessPolicy", AccessPolicyArgs.builder()
 *             .accessPolicyName("accessPolicy1")
 *             .cacheName("cache1")
 *             .permissions("+get +hget")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:AccessPolicy accessPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies/{accessPolicyName}
 * ```
 * @property accessPolicyName The name of the access policy that is being added to the Redis cache.
 * @property cacheName The name of the Redis cache.
 * @property permissions Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AccessPolicyArgs(
    public val accessPolicyName: Output<String>? = null,
    public val cacheName: Output<String>? = null,
    public val permissions: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.AccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.AccessPolicyArgs =
        com.pulumi.azurenative.cache.AccessPolicyArgs.builder()
            .accessPolicyName(accessPolicyName?.applyValue({ args0 -> args0 }))
            .cacheName(cacheName?.applyValue({ args0 -> args0 }))
            .permissions(permissions?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyArgs].
 */
@PulumiTagMarker
public class AccessPolicyArgsBuilder internal constructor() {
    private var accessPolicyName: Output<String>? = null

    private var cacheName: Output<String>? = null

    private var permissions: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the access policy that is being added to the Redis cache.
     */
    @JvmName("tpoqpwcyxfngsqlw")
    public suspend fun accessPolicyName(`value`: Output<String>) {
        this.accessPolicyName = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("emkudncshnbydedb")
    public suspend fun cacheName(`value`: Output<String>) {
        this.cacheName = value
    }

    /**
     * @param value Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
     */
    @JvmName("prtkrnywbsmoirin")
    public suspend fun permissions(`value`: Output<String>) {
        this.permissions = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lvoaskqjnasuyirf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the access policy that is being added to the Redis cache.
     */
    @JvmName("iqbtblhxjsduqsvf")
    public suspend fun accessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicyName = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("wjtpxrjtoyswghyv")
    public suspend fun cacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheName = mapped
    }

    /**
     * @param value Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
     */
    @JvmName("byfdlppcnbeiwdts")
    public suspend fun permissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aqesaskkypyfydms")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AccessPolicyArgs = AccessPolicyArgs(
        accessPolicyName = accessPolicyName,
        cacheName = cacheName,
        permissions = permissions,
        resourceGroupName = resourceGroupName,
    )
}
