@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.kotlin.outputs.DatabasePropertiesResponseGeoReplication
import com.pulumi.azurenative.cache.kotlin.outputs.ModuleResponse
import com.pulumi.azurenative.cache.kotlin.outputs.PersistenceResponse
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.cache.kotlin.outputs.DatabasePropertiesResponseGeoReplication.Companion.toKotlin as databasePropertiesResponseGeoReplicationToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.ModuleResponse.Companion.toKotlin as moduleResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.PersistenceResponse.Companion.toKotlin as persistenceResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Database].
 */
@PulumiTagMarker
public class DatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseArgs = DatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseArgsBuilder.() -> Unit) {
        val builder = DatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Database {
        val builtJavaResource = com.pulumi.azurenative.cache.Database(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Database(builtJavaResource)
    }
}

/**
 * Describes a database on the RedisEnterprise cluster
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01, 2024-02-01.
 * ## Example Usage
 * ### RedisEnterpriseDatabasesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Cache.Database("database", new()
 *     {
 *         ClientProtocol = AzureNative.Cache.Protocol.Encrypted,
 *         ClusterName = "cache1",
 *         ClusteringPolicy = AzureNative.Cache.ClusteringPolicy.EnterpriseCluster,
 *         DatabaseName = "default",
 *         EvictionPolicy = AzureNative.Cache.EvictionPolicy.AllKeysLRU,
 *         Modules = new[]
 *         {
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Args = "ERROR_RATE 0.00 INITIAL_SIZE 400",
 *                 Name = "RedisBloom",
 *             },
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Args = "RETENTION_POLICY 20",
 *                 Name = "RedisTimeSeries",
 *             },
 *             new AzureNative.Cache.Inputs.ModuleArgs
 *             {
 *                 Name = "RediSearch",
 *             },
 *         },
 *         Persistence = new AzureNative.Cache.Inputs.PersistenceArgs
 *         {
 *             AofEnabled = true,
 *             AofFrequency = AzureNative.Cache.AofFrequency.AofFrequency_1s,
 *         },
 *         Port = 10000,
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewDatabase(ctx, "database", &cache.DatabaseArgs{
 * 			ClientProtocol:   pulumi.String(cache.ProtocolEncrypted),
 * 			ClusterName:      pulumi.String("cache1"),
 * 			ClusteringPolicy: pulumi.String(cache.ClusteringPolicyEnterpriseCluster),
 * 			DatabaseName:     pulumi.String("default"),
 * 			EvictionPolicy:   pulumi.String(cache.EvictionPolicyAllKeysLRU),
 * 			Modules: cache.ModuleArray{
 * 				&cache.ModuleArgs{
 * 					Args: pulumi.String("ERROR_RATE 0.00 INITIAL_SIZE 400"),
 * 					Name: pulumi.String("RedisBloom"),
 * 				},
 * 				&cache.ModuleArgs{
 * 					Args: pulumi.String("RETENTION_POLICY 20"),
 * 					Name: pulumi.String("RedisTimeSeries"),
 * 				},
 * 				&cache.ModuleArgs{
 * 					Name: pulumi.String("RediSearch"),
 * 				},
 * 			},
 * 			Persistence: &cache.PersistenceArgs{
 * 				AofEnabled:   pulumi.Bool(true),
 * 				AofFrequency: pulumi.String(cache.AofFrequency_1s),
 * 			},
 * 			Port:              pulumi.Int(10000),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Database;
 * import com.pulumi.azurenative.cache.DatabaseArgs;
 * import com.pulumi.azurenative.cache.inputs.ModuleArgs;
 * import com.pulumi.azurenative.cache.inputs.PersistenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .clientProtocol("Encrypted")
 *             .clusterName("cache1")
 *             .clusteringPolicy("EnterpriseCluster")
 *             .databaseName("default")
 *             .evictionPolicy("AllKeysLRU")
 *             .modules(
 *                 ModuleArgs.builder()
 *                     .args("ERROR_RATE 0.00 INITIAL_SIZE 400")
 *                     .name("RedisBloom")
 *                     .build(),
 *                 ModuleArgs.builder()
 *                     .args("RETENTION_POLICY 20")
 *                     .name("RedisTimeSeries")
 *                     .build(),
 *                 ModuleArgs.builder()
 *                     .name("RediSearch")
 *                     .build())
 *             .persistence(PersistenceArgs.builder()
 *                 .aofEnabled(true)
 *                 .aofFrequency("1s")
 *                 .build())
 *             .port(10000)
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisEnterpriseDatabasesCreate With Active Geo Replication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Cache.Database("database", new()
 *     {
 *         ClientProtocol = AzureNative.Cache.Protocol.Encrypted,
 *         ClusterName = "cache1",
 *         ClusteringPolicy = AzureNative.Cache.ClusteringPolicy.EnterpriseCluster,
 *         DatabaseName = "default",
 *         EvictionPolicy = AzureNative.Cache.EvictionPolicy.NoEviction,
 *         GeoReplication = new AzureNative.Cache.Inputs.DatabasePropertiesGeoReplicationArgs
 *         {
 *             GroupNickname = "groupName",
 *             LinkedDatabases = new[]
 *             {
 *                 new AzureNative.Cache.Inputs.LinkedDatabaseArgs
 *                 {
 *                     Id = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default",
 *                 },
 *                 new AzureNative.Cache.Inputs.LinkedDatabaseArgs
 *                 {
 *                     Id = "/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default",
 *                 },
 *             },
 *         },
 *         Port = 10000,
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewDatabase(ctx, "database", &cache.DatabaseArgs{
 * 			ClientProtocol:   pulumi.String(cache.ProtocolEncrypted),
 * 			ClusterName:      pulumi.String("cache1"),
 * 			ClusteringPolicy: pulumi.String(cache.ClusteringPolicyEnterpriseCluster),
 * 			DatabaseName:     pulumi.String("default"),
 * 			EvictionPolicy:   pulumi.String(cache.EvictionPolicyNoEviction),
 * 			GeoReplication: &cache.DatabasePropertiesGeoReplicationArgs{
 * 				GroupNickname: pulumi.String("groupName"),
 * 				LinkedDatabases: cache.LinkedDatabaseArray{
 * 					&cache.LinkedDatabaseArgs{
 * 						Id: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default"),
 * 					},
 * 					&cache.LinkedDatabaseArgs{
 * 						Id: pulumi.String("/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default"),
 * 					},
 * 				},
 * 			},
 * 			Port:              pulumi.Int(10000),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Database;
 * import com.pulumi.azurenative.cache.DatabaseArgs;
 * import com.pulumi.azurenative.cache.inputs.DatabasePropertiesGeoReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .clientProtocol("Encrypted")
 *             .clusterName("cache1")
 *             .clusteringPolicy("EnterpriseCluster")
 *             .databaseName("default")
 *             .evictionPolicy("NoEviction")
 *             .geoReplication(DatabasePropertiesGeoReplicationArgs.builder()
 *                 .groupNickname("groupName")
 *                 .linkedDatabases(
 *                     LinkedDatabaseArgs.builder()
 *                         .id("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Cache/redisEnterprise/cache1/databases/default")
 *                         .build(),
 *                     LinkedDatabaseArgs.builder()
 *                         .id("/subscriptions/subid2/resourceGroups/rg2/providers/Microsoft.Cache/redisEnterprise/cache2/databases/default")
 *                         .build())
 *                 .build())
 *             .port(10000)
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:Database cache1/default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/databases/{databaseName}
 * ```
 */
public class Database internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.Database,
) : KotlinCustomResource(javaResource, DatabaseMapper) {
    /**
     * Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted.
     */
    public val clientProtocol: Output<String>?
        get() = javaResource.clientProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Clustering policy - default is OSSCluster. Specified at create time.
     */
    public val clusteringPolicy: Output<String>?
        get() = javaResource.clusteringPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Redis eviction policy - default is VolatileLRU
     */
    public val evictionPolicy: Output<String>?
        get() = javaResource.evictionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Optional set of properties to configure geo replication for this database.
     */
    public val geoReplication: Output<DatabasePropertiesResponseGeoReplication>?
        get() = javaResource.geoReplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    databasePropertiesResponseGeoReplicationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Optional set of redis modules to enable in this database - modules can only be added at creation time.
     */
    public val modules: Output<List<ModuleResponse>>?
        get() = javaResource.modules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> moduleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Persistence settings
     */
    public val persistence: Output<PersistenceResponse>?
        get() = javaResource.persistence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    persistenceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * TCP port of the database endpoint. Specified at create time. Defaults to an available port.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current provisioning status of the database
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Current resource status of the database
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseMapper : ResourceMapper<Database> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.Database::class == javaResource::class

    override fun map(javaResource: Resource): Database = Database(
        javaResource as
            com.pulumi.azurenative.cache.Database,
    )
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Database].
 */
public suspend fun database(name: String, block: suspend DatabaseResourceBuilder.() -> Unit):
    Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 */
public fun database(name: String): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
